/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.Colorizer;
import java.awt.Color;
import java.util.Arrays;

public class HSBColorizer
implements Colorizer {
    private float[] start;
    private float[] end;

    public HSBColorizer() {
        this(Color.white, new Color(16750918));
    }

    public HSBColorizer(Color start, Color end) {
        this.start = Color.RGBtoHSB(start.getRed(), start.getGreen(), start.getBlue(), new float[3]);
        this.end = Color.RGBtoHSB(end.getRed(), end.getGreen(), end.getBlue(), new float[3]);
        System.out.println("HSBColorizer start=" + Arrays.asList(start) + "  end=" + Arrays.asList(end));
    }

    public Color get(float value) {
        return new Color(Color.HSBtoRGB(this.start[0] * value + (1.0f - value) * this.end[0], this.start[1] * value + (1.0f - value) * this.end[1], this.start[2] * value + (1.0f - value) * this.end[2]));
    }
}

