/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.Colorizer;
import ch.randelshofer.tree.DefaultNodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import ch.randelshofer.tree.demo.FileNode;
import ch.randelshofer.tree.demo.LastModifiedWeighter;
import ch.randelshofer.tree.demo.RGBColorizer;
import ch.randelshofer.util.FileSizeFormat;
import java.awt.Color;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNodeInfo
extends DefaultNodeInfo {
    private FileSizeFormat shortWeightFormat;
    private FileSizeFormat longWeightFormat;
    private Colorizer colorizer = new RGBColorizer();
    private Weighter weighter = new LastModifiedWeighter();
    private static FileSizeFormat byteFormat = new FileSizeFormat();
    private static NumberFormat intFormat;

    public FileNodeInfo() {
        this.shortWeightFormat = new FileSizeFormat();
        this.shortWeightFormat.setShortFormat(true);
        this.shortWeightFormat.setMaximumFractionDigits(0);
        this.longWeightFormat = new FileSizeFormat();
        this.longWeightFormat.setMaximumFractionDigits(1);
        this.longWeightFormat.setAlwaysIncludeBytes(true);
    }

    @Override
    public void init(TreeNode root) {
        this.weighter.init(root);
        this.colorizer = new RGBColorizer(new float[]{0.0f, ((LastModifiedWeighter)this.weighter).getMedianWeight(), 1.0f}, new Color[]{new Color(6605055), new Color(0xF5F5F5), new Color(16750918)});
    }

    @Override
    public Weighter getWeighter() {
        return this.weighter;
    }

    @Override
    public Colorizer getColorizer() {
        return this.colorizer;
    }

    @Override
    public long getWeight(TreePath2<TreeNode> path) {
        FileNode fn = (FileNode)path.getLastPathComponent();
        return fn.getFileSize();
    }

    @Override
    public Color getColor(TreePath2<TreeNode> path) {
        FileNode fn = (FileNode)path.getLastPathComponent();
        return this.colorizer.get(this.weighter.getWeight(path));
    }

    @Override
    public String getName(TreePath2<TreeNode> path) {
        FileNode fn = (FileNode)path.getLastPathComponent();
        return fn.getName();
    }

    @Override
    public String getTooltip(TreePath2<TreeNode> path) {
        StringBuilder buf = new StringBuilder();
        TreePath2 parentPath = path;
        do {
            buf.insert(0, "<br>");
            buf.insert(0, this.getName(parentPath));
        } while ((parentPath = parentPath.getParentPath()) != null);
        buf.insert(0, "<html>");
        buf.append("<br>");
        FileNode node = (FileNode)path.getLastPathComponent();
        if (node.getAllowsChildren()) {
            buf.append("<br>children: ");
            buf.append(intFormat.format(node.children().size()));
            buf.append("<br>descendants: ");
            buf.append(intFormat.format(node.getDescendantCount()));
        }
        buf.append("<br>size: ");
        buf.append(this.longWeightFormat.format(this.getWeight(path)));
        buf.append("<br>last modified: ");
        buf.append(DateFormat.getDateTimeInstance().format(node.getLastModified()));
        return buf.toString();
    }

    @Override
    public String getWeightFormatted(TreePath2<TreeNode> path) {
        return this.shortWeightFormat.format(this.getWeight(path));
    }

    static {
        byteFormat.setShortFormat(false);
        byteFormat.setMaximumFractionDigits(1);
        intFormat = DecimalFormat.getIntegerInstance();
    }
}

