/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.gui.ProgressView;
import ch.randelshofer.tree.TreeNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileNode
implements TreeNode {
    private File file = null;
    private ArrayList<TreeNode> children = null;
    private int depth;
    private boolean isLeaf;
    private long fileSize = -1L;
    private int size = -1;
    private long lastModified;
    private int descendants = -1;

    public FileNode(File file) {
        this(null, 0, file);
    }

    public FileNode(File file, File onlyChild) {
        this(null, 0, file, onlyChild);
    }

    public FileNode(ProgressObserver p, int depth, File file) {
        this(p, depth, file, null);
    }

    public FileNode(ProgressObserver p, int depth, File file, File onlyChild) {
        ProgressObserver oldP = p;
        if (p == null) {
            p = new ProgressView("Opening " + file.getName(), "", 0, 1);
            p.setIndeterminate(true);
        }
        this.depth = depth;
        this.lastModified = file.lastModified();
        boolean isDir = file.isDirectory();
        this.isLeaf = !isDir;
        this.file = file;
        this.children = new ArrayList();
        if (this.isLeaf || p.isCanceled()) {
            this.fileSize = file.length();
        } else {
            File[] fileArray;
            p.setNote("Reading (" + p.getProgress() + ") " + file.getName());
            if (onlyChild == null) {
                fileArray = file.listFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = onlyChild;
            }
            File[] tabFichiers = fileArray;
            this.fileSize = 0L;
            if (tabFichiers != null) {
                p.setMaximum(p.getMaximum() + tabFichiers.length);
                for (File fichier : tabFichiers) {
                    if (fichier.isHidden()) continue;
                    FileNode child = new FileNode(p, depth + 1, fichier);
                    this.fileSize += child.getFileSize();
                    this.addChild(child);
                }
            }
        }
        this.size = this.fileSize == 0L ? 0 : Math.max(0, Math.min(10, (int)Math.log10(this.fileSize) - 5));
        p.setProgress(p.getProgress() + 1);
        if (oldP == null) {
            p.close();
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected void addChild(FileNode child) {
        this.children.add(child);
    }

    @Override
    public List<TreeNode> children() {
        return this.children;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf;
    }

    public String getName() {
        return this.file.getName();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getUnweightedSize() {
        return this.fileSize;
    }

    public float getWeight() {
        return (float)Math.min(1.0, Math.max(0.0, Math.log10((double)this.fileSize / 1.048576E7)));
    }

    public String getToolTipText() {
        long len = this.getFileSize();
        String unit = "bytes";
        if (len > 1024L) {
            unit = "KB";
            if ((len /= 1024L) > 1024L) {
                unit = "MB";
                if ((len /= 1024L) > 1024L) {
                    len /= 1024L;
                    unit = "GB";
                }
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append(this.getName());
        if (this.file.isDirectory()) {
            buf.append("<br>");
            buf.append(this.children.size());
            buf.append(" files");
        }
        buf.append("<br>");
        buf.append(len);
        buf.append(' ');
        buf.append(unit);
        buf.append("<br>");
        buf.append(new Date(this.file.lastModified()));
        return buf.toString();
    }

    public void dump(int depth) {
        System.out.println(depth + " " + this.getName());
        for (TreeNode c : this.children()) {
            FileNode child = (FileNode)c;
            child.dump(depth + 1);
        }
    }

    public int getDescendantCount() {
        if (this.descendants == -1) {
            this.descendants = 0;
            if (this.children != null) {
                this.descendants += this.children.size();
                for (TreeNode child : this.children) {
                    this.descendants += ((FileNode)child).getDescendantCount();
                }
            }
        }
        return this.descendants;
    }

    public String toString() {
        return "FileNode[" + this.getName() + "]";
    }
}

