/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.demo;

import ch.randelshofer.tree.NodeInfo;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeInfo
implements NodeInfo {
    /*
     * Enabled aggressive block sorting
     */
    public DataType determineDataType(Set<String> values) {
        DataType type;
        Iterator<String> iter = values.iterator();
        if (!iter.hasNext()) {
            return DataType.TEXT_STRING;
        }
        Matcher numberMatcher = Pattern.compile("^-?\\d+$").matcher("");
        Matcher dateMatcher = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}(T|\\s)\\d{2}:\\d{2}:\\d{2}$|^\\d{2}/\\d{2}/\\d{4}$").matcher("");
        String v = iter.next();
        if (v.equals("true") || v.equals("false")) {
            type = DataType.BOOLEAN_STRING;
        } else {
            numberMatcher.reset(v);
            if (numberMatcher.matches()) {
                type = DataType.NUMERIC_STRING;
            } else {
                dateMatcher.reset(v);
                type = dateMatcher.matches() ? DataType.DATE_STRING : DataType.TEXT_STRING;
            }
        }
        if (type == DataType.TEXT_STRING) return type;
        while (iter.hasNext()) {
            v = iter.next();
            switch (type) {
                case TEXT_STRING: {
                    return type;
                }
                case BOOLEAN_STRING: {
                    if (v.equals("true") || v.equals("false")) break;
                    return DataType.TEXT_STRING;
                }
                case NUMERIC_STRING: {
                    numberMatcher.reset(v);
                    if (numberMatcher.matches()) break;
                    return DataType.TEXT_STRING;
                }
                case DATE_STRING: {
                    dateMatcher.reset(v);
                    if (dateMatcher.matches()) break;
                    return DataType.TEXT_STRING;
                }
            }
        }
        return type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        TEXT_STRING,
        BOOLEAN_STRING,
        NUMERIC_STRING,
        DATE_STRING,
        LONG,
        INTEGER;

    }
}

