/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.circlemap;

import ch.randelshofer.tree.circlemap.Circle;
import ch.randelshofer.tree.circlemap.CircleRadiusComparator;
import ch.randelshofer.util.Complex;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Circles {
    private Circles() {
    }

    public static Rectangle2D.Double boundingBox(ArrayList<Circle> circles) {
        double minx = Double.MAX_VALUE;
        double maxx = Double.MIN_VALUE;
        double miny = Double.MAX_VALUE;
        double maxy = Double.MIN_VALUE;
        for (Circle c : circles) {
            minx = Math.min(minx, c.cx - c.radius);
            maxx = Math.max(maxx, c.cx + c.radius);
            miny = Math.min(miny, c.cy - c.radius);
            maxy = Math.max(maxy, c.cy + c.radius);
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
    }

    public static Circle boundingCircle(ArrayList<Circle> circles) {
        Circle outerSoddy = null;
        if (circles.size() >= 3) {
            outerSoddy = Circles.outerSoddyCircle(circles.get(0), circles.get(1), circles.get(2));
            for (Circle c : circles) {
                double dist = Math.sqrt((outerSoddy.cx - c.cx) * (outerSoddy.cx - c.cx) + (outerSoddy.cy - c.cy) * (outerSoddy.cy - c.cy));
                outerSoddy.radius = Math.max(outerSoddy.radius, dist + c.radius);
            }
        }
        Rectangle2D.Double bbox = Circles.boundingBox(circles);
        Circle bc = new Circle(bbox.getCenterX(), bbox.getCenterY(), Math.max(bbox.width, bbox.height) / 2.0);
        for (Circle c : circles) {
            double dist = Math.sqrt((bc.cx - c.cx) * (bc.cx - c.cx) + (bc.cy - c.cy) * (bc.cy - c.cy));
            bc.radius = Math.max(bc.radius, dist + c.radius);
        }
        return outerSoddy == null || bc.radius < outerSoddy.radius ? bc : outerSoddy;
    }

    public static void phyllotacticPack(ArrayList<Circle> circles) {
        switch (circles.size()) {
            case 0: {
                break;
            }
            case 1: {
                Circle circle = circles.get(0);
                circle.cx = 0.0;
                circle.cy = 0.0;
                break;
            }
            case 2: {
                Circle c0 = circles.get(0);
                Circle c1 = circles.get(1);
                double radius = c0.radius + c1.radius;
                c0.cx = c0.radius - radius;
                c1.cx = radius - c1.radius;
                c1.cy = 0.0;
                c0.cy = 0.0;
                break;
            }
            case 3: {
                ArrayList sorted = (ArrayList)circles.clone();
                Collections.sort(sorted, CircleRadiusComparator.getDescendingInstance());
                Circle ca = (Circle)sorted.get(0);
                Circle cb = (Circle)sorted.get(1);
                Circle cc = (Circle)sorted.get(2);
                double a = cb.radius + cc.radius;
                double b = ca.radius + cc.radius;
                double c = ca.radius + cb.radius;
                double area = Math.sqrt(ca.radius * cb.radius * cc.radius * (ca.radius + cb.radius + cc.radius));
                double hc = 2.0 * area / c;
                ca.cx = -ca.radius;
                ca.cy = 0.0;
                cb.cx = cb.radius;
                cb.cy = 0.0;
                cc.cx = ca.cx + Math.sqrt(b * b - hc * hc);
                cc.cy = hc;
                break;
            }
            case 4: {
                ArrayList sorted = (ArrayList)circles.clone();
                Collections.sort(sorted, CircleRadiusComparator.getDescendingInstance());
                Circle ca = (Circle)sorted.get(0);
                Circle cb = (Circle)sorted.get(1);
                Circle cc = (Circle)sorted.get(2);
                double a = cb.radius + cc.radius;
                double b = ca.radius + cc.radius;
                double c = ca.radius + cb.radius;
                double area = Math.sqrt(ca.radius * cb.radius * cc.radius * (ca.radius + cb.radius + cc.radius));
                double hc = 2.0 * area / c;
                ca.cx = -ca.radius;
                ca.cy = 0.0;
                cb.cx = cb.radius;
                cb.cy = 0.0;
                cc.cx = ca.cx + Math.sqrt(b * b - hc * hc);
                cc.cy = hc;
                cc = (Circle)sorted.get(3);
                b = ca.radius + cc.radius;
                area = Math.sqrt(ca.radius * cb.radius * cc.radius * (ca.radius + cb.radius + cc.radius));
                hc = 2.0 * area / c;
                cc.cx = ca.cx + Math.sqrt(b * b - hc * hc);
                cc.cy = -hc;
                break;
            }
            default: {
                ArrayList sorted = (ArrayList)circles.clone();
                Collections.sort(sorted, CircleRadiusComparator.getDescendingInstance());
                if (((Circle)sorted.get(0)).getRadius() <= ((Circle)sorted.get(sorted.size() - 1)).getRadius() * 1.1) {
                    double c = Math.max(0.1, ((Circle)sorted.get((int)(sorted.size() - 1))).radius * 1.25);
                    int m = sorted.size();
                    for (int i = 0; i < m; ++i) {
                        Circle circle = (Circle)sorted.get(i);
                        double cr = c * Math.sqrt(i + 1);
                        double ct = (double)(i + 1) * 137.5 * Math.PI / 180.0;
                        circle.cx = cr * Math.sin(ct);
                        circle.cy = cr * Math.cos(ct);
                    }
                    break;
                }
                double c = Math.max(0.1, ((Circle)sorted.get((int)(sorted.size() - 1))).radius * 1.25);
                int m = sorted.size();
                for (int i = 0; i < m; ++i) {
                    Circle circle = (Circle)sorted.get(i);
                    double cr = c * Math.sqrt(i + 1);
                    double ct = (double)(i + 1) * 137.5 * Math.PI / 180.0;
                    circle.cx = cr * Math.sin(ct);
                    circle.cy = cr * Math.cos(ct);
                }
                boolean intersects = false;
                int iteration = 0;
                do {
                    intersects = false;
                    int m2 = sorted.size();
                    for (int i = 0; i < m2; ++i) {
                        Circle ci = (Circle)sorted.get(i);
                        for (int j = i + 1; j < m2; ++j) {
                            Circle cj = (Circle)sorted.get(j);
                            double dist2 = (ci.cx - cj.cx) * (ci.cx - cj.cx) + (ci.cy - cj.cy) * (ci.cy - cj.cy);
                            double requiredDist = ci.radius + cj.radius;
                            if (!(dist2 < requiredDist * requiredDist)) continue;
                            double dist = Math.sqrt(dist2);
                            double theta = Math.atan2(cj.cy, cj.cx);
                            double dx = (requiredDist - dist + 0.01) * Math.cos(theta);
                            double dy = (requiredDist - dist + 0.01) * Math.sin(theta);
                            cj.cx += dx;
                            cj.cy += dy;
                            intersects = true;
                        }
                    }
                } while (intersects && ++iteration < 100);
            }
        }
    }

    public static void pairPack(ArrayList<Circle> circles) {
        double error = 0.01;
        switch (circles.size()) {
            case 0: {
                break;
            }
            case 1: {
                Circle circle = circles.get(0);
                circle.cx = 0.0;
                circle.cy = 0.0;
                break;
            }
            case 2: {
                Circle c0 = circles.get(0);
                Circle c1 = circles.get(1);
                double radius = c0.radius + c1.radius;
                c0.cx = c0.radius - radius;
                c1.cx = radius - c1.radius;
                c1.cy = 0.0;
                c0.cy = 0.0;
                break;
            }
            case 4: {
                ArrayList sorted = (ArrayList)circles.clone();
                Collections.sort(sorted, CircleRadiusComparator.getDescendingInstance());
                if (((Circle)sorted.get((int)0)).radius / ((Circle)sorted.get((int)3)).radius < 1.3) {
                    Circle c0 = (Circle)sorted.get(0);
                    Circle c1 = (Circle)sorted.get(1);
                    Circle c2 = (Circle)sorted.get(2);
                    Circle c3 = (Circle)sorted.get(3);
                    c0.cx = c0.cy = -c0.radius;
                    c1.cx = c1.cy = c1.radius;
                    c2.cx = c2.radius;
                    c2.cy = -c2.radius;
                    c3.cx = -c3.radius;
                    c3.cy = c3.radius;
                    break;
                }
            }
            default: {
                ArrayList sorted = (ArrayList)circles.clone();
                Collections.sort(sorted, CircleRadiusComparator.getDescendingInstance());
                Circle ca = (Circle)sorted.get(0);
                Circle cb = (Circle)sorted.get(1);
                Circle cc = (Circle)sorted.get(2);
                double a = cb.radius + cc.radius;
                double b = ca.radius + cc.radius;
                double c = ca.radius + cb.radius;
                double area = Math.sqrt(ca.radius * cb.radius * cc.radius * (ca.radius + cb.radius + cc.radius));
                double hc = 2.0 * area / c;
                ca.cx = -ca.radius;
                ca.cy = 0.0;
                cb.cx = cb.radius;
                cb.cy = 0.0;
                cc.cx = ca.cx + Math.sqrt(b * b - hc * hc);
                cc.cy = hc;
                Point2D.Double cp = new Point2D.Double();
                AffineTransform transform = new AffineTransform();
                double shift = ca.radius - cb.radius;
                ca.cx += shift;
                cb.cx += shift;
                cc.cx += shift;
                if (sorted.size() <= 3) break;
                double smallestRadius = ((Circle)sorted.get((int)(sorted.size() - 1))).radius;
                ArrayList<Pair> pairs = new ArrayList<Pair>();
                pairs.add(new Pair(cb, ca));
                pairs.add(new Pair(ca, cc));
                pairs.add(new Pair(cc, cb));
                double innerSoddyRadius = Circles.innerSoddyRadius(ca.radius, cb.radius, cc.radius);
                if (innerSoddyRadius >= smallestRadius) {
                    pairs.add(new Pair(ca, cb, innerSoddyRadius));
                    pairs.add(new Pair(cc, ca, innerSoddyRadius));
                    pairs.add(new Pair(cb, cc, innerSoddyRadius));
                }
                Point2D.Double closestPoint = new Point2D.Double();
                int closestEdgeIndex = -1;
                Pair closestEdge = null;
                for (int i = 3; i < sorted.size(); ++i) {
                    cc = (Circle)sorted.get(i);
                    closestPoint.x = Double.MAX_VALUE;
                    closestPoint.y = Double.MAX_VALUE;
                    closestEdgeIndex = -1;
                    closestEdge = null;
                    for (int pairIndex = 0; pairIndex < pairs.size(); ++pairIndex) {
                        boolean intersects;
                        Pair pair = (Pair)pairs.get(pairIndex);
                        if (pair.innerSoddyRadius < cc.radius - error) {
                            intersects = true;
                        } else {
                            ca = pair.ca;
                            cb = pair.cb;
                            a = cb.radius + cc.radius;
                            b = ca.radius + cc.radius;
                            c = ca.radius + cb.radius;
                            area = Math.sqrt(ca.radius * cb.radius * cc.radius * (ca.radius + cb.radius + cc.radius));
                            hc = 2.0 * area / c;
                            cp.x = Math.sqrt(b * b - hc * hc);
                            cp.y = hc;
                            double theta = Math.atan2(cb.cy - ca.cy, cb.cx - ca.cx);
                            transform.setToIdentity();
                            transform.translate(ca.cx, ca.cy);
                            transform.rotate(theta);
                            transform.transform(cp, cp);
                            if (cp.x * cp.x + cp.y * cp.y >= closestPoint.x * closestPoint.x + closestPoint.y * closestPoint.y) {
                                intersects = true;
                            } else {
                                intersects = false;
                                cc.cx = cp.x;
                                cc.cy = cp.y;
                                for (int j = 0; j < i; ++j) {
                                    if (!cc.intersects((Circle)sorted.get(j), error)) continue;
                                    pair.innerSoddyRadius = cc.getIntersectionRadius((Circle)sorted.get(j));
                                    intersects = true;
                                    break;
                                }
                            }
                        }
                        if (intersects || !(cc.cx * cc.cx + cc.cy * cc.cy < closestPoint.x * closestPoint.x + closestPoint.y * closestPoint.y)) continue;
                        closestPoint.x = cc.cx;
                        closestPoint.y = cc.cy;
                        closestEdgeIndex = pairIndex;
                        closestEdge = (Pair)pairs.get(closestEdgeIndex);
                    }
                    cc.cx = closestPoint.x;
                    cc.cy = closestPoint.y;
                    ca = ((Pair)pairs.get((int)closestEdgeIndex)).ca;
                    cb = ((Pair)pairs.get((int)closestEdgeIndex)).cb;
                    innerSoddyRadius = Circles.innerSoddyRadius(ca.radius, cb.radius, cc.radius);
                    if (innerSoddyRadius >= smallestRadius) {
                        ((Pair)pairs.get((int)closestEdgeIndex)).innerSoddyRadius = innerSoddyRadius;
                        pairs.add(new Pair(cc, ca, innerSoddyRadius));
                        pairs.add(new Pair(cb, cc, innerSoddyRadius));
                    } else {
                        pairs.remove(closestEdgeIndex);
                    }
                    pairs.add(new Pair(ca, cc));
                    pairs.add(new Pair(cc, cb));
                }
            }
        }
    }

    public static double innerSoddyRadius(double ra, double rb, double rc) {
        return ra * rb * rc / (ra * rc + ra * rb + rb * rc + Math.sqrt(4.0 * ra * rb * rc * (ra + rb + rc)));
    }

    public static double outerSoddyRadius(double ra, double rb, double rc) {
        return Math.abs(ra * rb * rc / (ra * rc + ra * rb + rb * rc - Math.sqrt(4.0 * ra * rb * rc * (ra + rb + rc))));
    }

    public static double circumradius(double ra, double rb, double rc) {
        double a = rb + rc;
        double b = ra + rc;
        double c = ra + rb;
        double r = a * b * c / Math.sqrt((a + b + c) * (b + c - a) * (c + a - b) * (a + b - c));
        return r;
    }

    public static Circle outerSoddyCircle(Circle circleA, Circle circleB, Circle circleC) {
        double ra = circleA.radius;
        double rb = circleB.radius;
        double rc = circleC.radius;
        double k1 = 1.0 / ra;
        double k2 = 1.0 / rb;
        double k3 = 1.0 / rc;
        double k4 = Math.abs(k1 + k2 + k3 - 2.0 * Math.sqrt(k1 * k2 + k2 * k3 + k3 * k1));
        Complex q1 = new Complex(k1, 0.0).mul(new Complex(circleA.cx, circleA.cy));
        Complex q2 = new Complex(k2, 0.0).mul(new Complex(circleB.cx, circleB.cy));
        Complex q3 = new Complex(k3, 0.0).mul(new Complex(circleC.cx, circleC.cy));
        Complex q4 = q1.add(q2).add(q3).sub(new Complex(2.0, 0.0).mul(q1.mul(q2).add(q2.mul(q3)).add(q3.mul(q1)).sqrt()));
        Complex z = q4.div(new Complex(k4, 0.0));
        if (z.isNaN() || Double.isNaN(1.0 / k4)) {
            return new Circle();
        }
        return new Circle(-z.real(), -z.img(), 1.0 / k4);
    }

    public static void main(String[] arg) {
        Circle a = new Circle(1.4210854715202004E-14, -54.162200020584606, 18.0540666735282);
        Circle b = new Circle(-72.2162666941128, 0.0, 72.2162666941128);
        Circle c = new Circle(72.2162666941128, 0.0, 72.2162666941128);
        System.out.println("C:" + Circles.outerSoddyCircle(a, b, c));
        a = new Circle(-3.552713678800501E-15, -31.842677395339436, 18.0540666735282);
        b = new Circle(36.09065056202983, -32.9661700825705, 18.0540666735282);
        c = new Circle(-36.090650562029836, -32.9661700825705, 18.0540666735282);
        System.out.println("B:" + Circles.outerSoddyCircle(a, b, c));
        System.out.flush();
    }

    private static class Pair {
        public Circle ca;
        public Circle cb;
        public double innerSoddyRadius = Double.MAX_VALUE;

        public Pair(Circle ca, Circle cb) {
            this.ca = ca;
            this.cb = cb;
        }

        public Pair(Circle ca, Circle cb, double innerSoddyRadius) {
            this.ca = ca;
            this.cb = cb;
            this.innerSoddyRadius = innerSoddyRadius;
        }
    }
}

