/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.circlemap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.gui.ProgressTracker;
import ch.randelshofer.tree.TreeView;
import ch.randelshofer.tree.circlemap.CirclemapDraw;
import ch.randelshofer.tree.circlemap.CirclemapNode;
import ch.randelshofer.tree.circlemap.CirclemapTree;
import ch.randelshofer.util.SequentialDispatcher;
import ch.randelshofer.util.Worker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CirclemapView
extends JPanel
implements TreeView {
    private CirclemapDraw draw;
    private BufferedImage img;
    private boolean isInvalid;
    private ProgressObserver workerProgress;
    private boolean drawHandles;
    private boolean isAdjusting;
    private boolean needsSimplify;
    private boolean needsProgressive = true;
    private CirclemapNode hoverNode;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private boolean isToolTipVisible = false;

    public CirclemapView() {
    }

    public CirclemapView(CirclemapTree model) {
        this.draw = new CirclemapDraw(model.getRoot(), model.getInfo());
        model.getInfo().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CirclemapView.this.isInvalid = true;
                CirclemapView.this.repaint();
            }
        });
        this.init();
    }

    private void init() {
        this.initComponents();
        MouseHandler handler = new MouseHandler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setToolTipEnabled(boolean newValue) {
        this.isToolTipVisible = newValue;
    }

    public boolean isToolTipEnabled() {
        return this.isToolTipVisible;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.isToolTipVisible) {
            return this.getInfoText(event);
        }
        return null;
    }

    public String getInfoText(MouseEvent event) {
        int y;
        int x = event.getX();
        CirclemapNode node = this.draw.getNodeAt(x, y = event.getY());
        return node == null ? null : this.draw.getInfo().getTooltip(node.getDataNodePath());
    }

    private void setCenter(double cx, double cy) {
        this.draw.setCX(cx);
        this.draw.setCY(cy);
    }

    private void setOuterRadius(double r) {
        this.draw.setRadius(r);
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.img == null || this.img.getWidth() != w || this.img.getHeight() != h) {
            if (this.img == null) {
                this.setCenter((double)w / 2.0, (double)h / 2.0);
                this.setOuterRadius(Math.min(w, h) / 2 - 4);
            } else {
                this.setCenter(this.draw.getCX() / (double)this.img.getWidth() * (double)w, this.draw.getCY() / (double)this.img.getHeight() * (double)h);
                this.setOuterRadius(Math.min(w, h) / 2 - 4);
            }
            this.img = null;
            this.img = new BufferedImage(w, h, 1);
            Graphics2D g2 = this.img.createGraphics();
            g2.setBackground(Color.WHITE);
            g2.clearRect(0, 0, this.img.getWidth(), this.img.getHeight());
            g2.dispose();
            this.isInvalid = true;
        }
        if (this.isInvalid) {
            if (this.workerProgress != null) {
                this.workerProgress.cancel();
            } else {
                this.isInvalid = false;
                final BufferedImage workingImage = this.img;
                this.workerProgress = new ProgressTracker("Rectangular Treemap", "Drawing...");
                this.workerProgress.setIndeterminate(true);
                final Timer timer = new Timer(33, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        CirclemapView.this.repaint();
                    }
                });
                timer.isRepeats();
                timer.start();
                Worker worker = new Worker(){

                    public Object construct() {
                        Graphics2D g = workingImage.createGraphics();
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setBackground(Color.WHITE);
                        g.setFont(CirclemapView.this.getFont());
                        g.clearRect(0, 0, workingImage.getWidth(), workingImage.getHeight());
                        g.setClip(new Rectangle(0, 0, workingImage.getWidth(), workingImage.getHeight()));
                        if (CirclemapView.this.isAdjusting && CirclemapView.this.needsSimplify) {
                            long start = System.currentTimeMillis();
                            CirclemapView.this.draw.drawTree(g, CirclemapView.this.workerProgress);
                            long end = System.currentTimeMillis();
                            CirclemapView.this.needsSimplify = (byte)(CirclemapView.this.needsSimplify | (end - start > 99L ? 1 : 0));
                            CirclemapView.this.needsProgressive = (byte)(CirclemapView.this.needsProgressive | (end - start > 33L ? 1 : 0));
                        } else {
                            long start = System.currentTimeMillis();
                            CirclemapView.this.draw.drawTree(g, CirclemapView.this.workerProgress);
                            long end = System.currentTimeMillis();
                            CirclemapView.this.needsSimplify = end - start > 99L;
                            CirclemapView.this.needsProgressive = end - start > 33L;
                        }
                        g.dispose();
                        return null;
                    }

                    public void done(Object value) {
                        CirclemapView.this.workerProgress.close();
                        CirclemapView.this.workerProgress = null;
                        CirclemapView.this.repaint();
                        timer.stop();
                    }
                };
                if (this.needsProgressive) {
                    this.dispatcher.dispatch(worker);
                } else {
                    worker.run();
                }
            }
        }
        gr.drawImage(this.img, 0, 0, this);
        CirclemapNode selectedNode = this.draw.getDrawRoot();
        if (selectedNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (selectedNode.children().size() == 0) {
                this.draw.drawSubtreeBounds(g, selectedNode, Color.blue);
            } else {
                this.draw.drawDescendantSubtreeBounds(g, selectedNode, Color.blue);
            }
        }
        if (this.hoverNode != null) {
            g = (Graphics2D)gr;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.draw.drawNodeBounds(g, this.hoverNode, Color.red);
        }
        if (this.drawHandles) {
            g = (Graphics2D)gr;
            double cx = this.draw.getCX();
            double cy = this.draw.getCY();
            g.setColor(Color.BLACK);
            AffineTransform t = new AffineTransform();
            t.translate(cx, cy);
            AffineTransform oldT = (AffineTransform)g.getTransform().clone();
            g.setTransform(t);
            g.draw(new Line2D.Double(-5.0, 0.0, 5.0, 0.0));
            g.draw(new Line2D.Double(0.0, -5.0, 0.0, 5.0));
            g.setTransform(oldT);
        }
    }

    public void setMaxDepth(int newValue) {
        if (newValue != this.draw.getMaxDepth()) {
            this.draw.setMaxDepth(newValue);
            this.isInvalid = true;
            if (newValue == Integer.MAX_VALUE) {
                this.needsProgressive = true;
            }
            this.repaint();
        }
    }

    public int getMaxDepth() {
        return this.draw.getMaxDepth();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            CirclemapNode node = CirclemapView.this.draw.getNodeAt(evt.getX(), evt.getY());
            if (node == null) {
                node = CirclemapView.this.draw.getRoot();
            }
            if (node != CirclemapView.this.draw.getDrawRoot()) {
                CirclemapView.this.draw.setDrawRoot(node);
                CirclemapView.this.isInvalid = true;
                CirclemapView.this.repaint();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent evt) {
            CirclemapView.this.hoverNode = CirclemapView.this.draw.getNodeAt(evt.getX(), evt.getY());
            CirclemapView.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            CirclemapView.this.hoverNode = null;
            CirclemapView.this.repaint();
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent evt) {
            CirclemapView.this.hoverNode = CirclemapView.this.draw.getNodeAt(evt.getX(), evt.getY());
            CirclemapView.this.repaint();
        }
    }
}

