/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.circlemap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.circlemap.CirclemapCompositeNode;
import ch.randelshofer.tree.circlemap.CirclemapNode;

public class CirclemapTree {
    private CirclemapNode root;
    private NodeInfo info;

    public CirclemapTree(TreeNode root, NodeInfo info, ProgressObserver p) {
        p.setNote("Constructing tree\u2026");
        this.info = info;
        this.root = !root.getAllowsChildren() ? new CirclemapNode(null, root) : new CirclemapCompositeNode(null, root);
        info.init(root);
        long start = System.currentTimeMillis();
        p.setNote("Calculating layout\u2026");
        p.setMaximum(p.getMaximum() + this.root.getDescendantCount());
        p.setIndeterminate(false);
        this.root.layout(info, p);
        long end = System.currentTimeMillis();
        System.out.println("CirclemapTree layout elapsed " + (end - start) + "ms");
    }

    public NodeInfo getInfo() {
        return this.info;
    }

    public CirclemapNode getRoot() {
        return this.root;
    }
}

