/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.circlemap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.circlemap.Circle;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CirclemapNode
extends Circle {
    private CirclemapNode parent;
    private TreePath2<TreeNode> dataNodePath;

    public CirclemapNode(CirclemapNode parent, TreeNode data) {
        this.parent = parent;
        this.dataNodePath = parent == null ? new TreePath2(data) : parent.getDataNodePath().pathByAddingChild(data);
    }

    public List<CirclemapNode> children() {
        return Collections.EMPTY_LIST;
    }

    public boolean isLeaf() {
        return true;
    }

    public TreePath2<TreeNode> getDataNodePath() {
        return this.dataNodePath;
    }

    public void layout(NodeInfo info, ProgressObserver p) {
        this.radius = this.getWeightRadius(info);
    }

    public double getWeightRadius(NodeInfo info) {
        return Math.max(1.0, Math.sqrt((double)info.getWeight(this.dataNodePath) / Math.PI));
    }

    public CirclemapNode getParent() {
        return this.parent;
    }

    public TreeNode getDataNode() {
        return this.dataNodePath.getLastPathComponent();
    }

    @Override
    public String toString() {
        return this.getClass() + "[x:" + this.cx + ",y:" + this.cy + ",r:" + this.radius + "]";
    }

    public int getDescendantCount() {
        return 0;
    }
}

