/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.circlemap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.circlemap.CirclemapNode;
import ch.randelshofer.tree.circlemap.CirclemapTree;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class CirclemapDraw {
    private CirclemapNode root;
    private CirclemapNode drawRoot;
    private NodeInfo info;
    private double cx = 100.0;
    private double cy = 100.0;
    private double radius = 96.0;
    private double scaleFactor = 1.0;
    private int maxDepth = Integer.MAX_VALUE;

    public CirclemapDraw(CirclemapTree model) {
        this(model.getRoot(), model.getInfo());
    }

    public CirclemapDraw(CirclemapNode root, NodeInfo info) {
        this.drawRoot = this.root = root;
        this.info = info;
    }

    public double getCX() {
        return this.cx;
    }

    public void setCX(double newValue) {
        this.cx = newValue;
    }

    public double getCY() {
        return this.cy;
    }

    public void setCY(double newValue) {
        this.cy = newValue;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double newValue) {
        this.radius = newValue;
    }

    public void drawTree(Graphics2D g, ProgressObserver p) {
        this.scaleFactor = this.radius / this.drawRoot.getRadius();
        double sx = 0.0;
        double sy = 0.0;
        CirclemapNode node = this.drawRoot;
        int depth = 1;
        while (node != null) {
            sx -= node.getCX();
            sy -= node.getCY();
            node = node.getParent();
            --depth;
        }
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds == null) {
            clipBounds = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        this.drawTree0(g, this.root, depth, sx, sy, this.scaleFactor, clipBounds, p);
    }

    public void drawTree0(Graphics2D g, CirclemapNode node, int depth, double px, double py, double sf, Rectangle clipBounds, ProgressObserver p) {
        if (!p.isCanceled()) {
            this.drawNode(g, node, depth, px, py, sf);
            this.drawLabel(g, node, depth, px, py, sf);
            if (node.radius * sf > 1.0 && node.children().size() > 0) {
                double r = node.getRadius() * sf;
                Rectangle2D.Double bounds = new Rectangle2D.Double(this.cx + sf * px - r, this.cy + sf * py - r, r * 2.0, r * 2.0);
                if (depth < this.maxDepth && clipBounds.intersects(bounds)) {
                    for (CirclemapNode child : node.children()) {
                        this.drawTree0(g, child, depth + 1, px + child.getCX(), py + child.getCY(), sf, clipBounds, p);
                    }
                }
            }
        }
    }

    public void drawNode(Graphics2D g, CirclemapNode node, int depth, double px, double py, double sf) {
        double r = node.getRadius() * sf;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(this.cx + sf * px - r, this.cy + sf * py - r, r * 2.0, r * 2.0);
        if (node.isLeaf()) {
            g.setColor(this.info.getColor(node.getDataNodePath()));
            g.fill(ellipse);
            g.setColor(this.info.getColor(node.getDataNodePath()).darker());
            g.draw(ellipse);
        } else if (depth == this.maxDepth) {
            double r2 = node.getWeightRadius(this.info) * sf;
            ellipse.x = this.cx + sf * px - r2;
            ellipse.y = this.cy + sf * py - r2;
            ellipse.width = ellipse.height = r2 * 2.0;
            g.setColor(this.info.getColor(node.getDataNodePath()));
            g.fill(ellipse);
            g.setColor(this.info.getColor(node.getDataNodePath()).darker());
            g.draw(ellipse);
        } else {
            g.setColor(this.info.getColor(node.getDataNodePath()).darker());
            g.draw(ellipse);
        }
    }

    public void drawLabel(Graphics2D g, CirclemapNode node, int depth, double px, double py, double sf) {
        if (node.children().size() == 0 || depth == this.maxDepth) {
            double r = depth == this.maxDepth ? node.getWeightRadius(this.info) * sf : node.getRadius() * sf;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(this.cx + sf * px - r, this.cy + sf * py - r, r * 2.0, r * 2.0);
            FontMetrics fm = g.getFontMetrics();
            int fh = fm.getHeight();
            if ((double)fh < ellipse.height) {
                int nameWidth;
                int nameLength;
                char[] nameC;
                String name;
                String weightStr;
                int weightWidth;
                g.setColor(Color.BLACK);
                double space = ellipse.width - 6.0;
                int y = (int)(ellipse.y + (ellipse.height - (double)fh) / 2.0) + fm.getAscent();
                if ((double)(fh * 2) < ellipse.height && (double)(weightWidth = fm.stringWidth(weightStr = this.info.getWeightFormatted(node.getDataNodePath()))) < space) {
                    g.drawString(weightStr, (int)(ellipse.x + (ellipse.width - (double)weightWidth) / 2.0), y + fh / 2);
                    y -= fh / 2;
                }
                if (node.children().size() == 0) {
                    name = this.info.getName(node.getDataNodePath());
                    nameC = name.toCharArray();
                    nameLength = nameC.length;
                    nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    while ((double)nameWidth >= space && nameLength > 1) {
                        nameC[--nameLength - 1] = 183;
                        nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    }
                } else {
                    name = this.info.getName(node.getDataNodePath()) + "\u203a";
                    nameC = name.toCharArray();
                    nameLength = nameC.length;
                    nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    while ((double)nameWidth >= space && nameLength > 1) {
                        nameC[--nameLength - 1] = 8250;
                        nameWidth = fm.charsWidth(nameC, 0, nameLength);
                    }
                }
                if (nameLength > 1 || nameLength == nameC.length) {
                    g.drawString(new String(nameC, 0, nameLength), (int)(ellipse.x + (ellipse.width - (double)nameWidth) / 2.0), y);
                }
            }
        }
    }

    public void drawContours(Graphics2D g, CirclemapNode node, Color color) {
    }

    public NodeInfo getInfo() {
        return this.info;
    }

    public CirclemapNode getRoot() {
        return this.root;
    }

    public CirclemapNode getDrawRoot() {
        return this.drawRoot;
    }

    public void setDrawRoot(CirclemapNode newValue) {
        this.drawRoot = newValue;
    }

    public void drawNodeBounds(Graphics2D g, CirclemapNode selectedNode, Color color) {
        CirclemapNode node;
        g.setColor(color);
        double r = selectedNode.getRadius() * this.scaleFactor;
        double scx = 0.0;
        double scy = 0.0;
        for (node = selectedNode; node != null; node = node.getParent()) {
            scx += node.getCX();
            scy += node.getCY();
        }
        for (node = this.drawRoot; node != null; node = node.getParent()) {
            scx -= node.getCX();
            scy -= node.getCY();
        }
        double px = scx * this.scaleFactor + this.cx;
        double py = scy * this.scaleFactor + this.cy;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(px - r, py - r, r * 2.0, r * 2.0);
        g.draw(ellipse);
    }

    public void drawSubtreeBounds(Graphics2D g, CirclemapNode selectedNode, Color color) {
    }

    public void drawDescendantSubtreeBounds(Graphics2D g, CirclemapNode parent, Color color) {
    }

    public CirclemapNode getNodeAt(int px, int py) {
        return this.getNodeAt(((double)px - this.cx) / this.scaleFactor, ((double)py - this.cy) / this.scaleFactor);
    }

    public CirclemapNode getNodeAt(double px, double py) {
        CirclemapNode parent = this.drawRoot;
        int depth = 1;
        while (parent != null) {
            px += parent.getCX();
            py += parent.getCY();
            parent = parent.getParent();
            --depth;
        }
        if (this.root.contains(px, py)) {
            CirclemapNode found;
            parent = found = this.root;
            block1: do {
                parent = found;
                px -= parent.cx;
                py -= parent.cy;
                for (CirclemapNode node : parent.children()) {
                    if (!node.contains(px, py)) continue;
                    found = node;
                    ++depth;
                    continue block1;
                }
            } while (found != parent && depth < this.maxDepth);
            return found;
        }
        return null;
    }

    public void setMaxDepth(int newValue) {
        this.maxDepth = newValue;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }
}

