/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.circlemap;

import ch.randelshofer.gui.ProgressObserver;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.circlemap.Circle;
import ch.randelshofer.tree.circlemap.CirclemapNode;
import ch.randelshofer.tree.circlemap.Circles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CirclemapCompositeNode
extends CirclemapNode {
    private int descendants = -1;
    private ArrayList<CirclemapNode> children = new ArrayList();

    public CirclemapCompositeNode(CirclemapNode parent, TreeNode node) {
        super(parent, node);
        for (TreeNode c : node.children()) {
            if (!c.getAllowsChildren()) {
                this.children.add(new CirclemapNode(this, c));
                continue;
            }
            this.children.add(new CirclemapCompositeNode(this, c));
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<CirclemapNode> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void layout(NodeInfo info, ProgressObserver p) {
        if (p.isCanceled()) {
            return;
        }
        for (CirclemapNode child : this.children) {
            child.layout(info, p);
        }
        if (this.children.size() == 0) {
            this.radius = 10.0;
            return;
        }
        if (this.children.size() == 1) {
            this.radius = this.children.get((int)0).radius + 1.0;
            return;
        }
        ArrayList<Circle> circles = new ArrayList<Circle>();
        circles.addAll(this.children);
        Circles.pairPack(circles);
        Circle cbounds = Circles.boundingCircle(circles);
        this.radius = cbounds.radius;
        for (CirclemapNode child : this.children) {
            child.cx -= cbounds.cx;
            child.cy -= cbounds.cy;
        }
        p.setProgress(p.getProgress() + this.children.size());
    }

    @Override
    public int getDescendantCount() {
        if (this.descendants == -1) {
            this.descendants += this.children.size();
            for (CirclemapNode child : this.children) {
                this.descendants += child.getDescendantCount();
            }
        }
        return this.descendants;
    }
}

