/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree.circlemap;

public class Circle
implements Cloneable {
    public double cx;
    public double cy;
    public double radius;

    public Circle() {
    }

    public Circle(double cx, double cy, double r) {
        this.cx = cx;
        this.cy = cy;
        this.radius = r;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getCX() {
        return this.cx;
    }

    public double getCY() {
        return this.cy;
    }

    public boolean intersects(Circle that) {
        return this.intersects(that, 0.0);
    }

    public boolean intersects(Circle that, double error) {
        double dist = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
        return dist < (this.radius + that.radius) * (this.radius + that.radius) - error;
    }

    public double getIntersectionRadius(Circle that) {
        double dist = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
        return Math.sqrt(dist) - that.radius;
    }

    public boolean contains(Circle that) {
        return this.contains(that, 0.0);
    }

    public boolean contains(Circle that, double error) {
        double dist = Math.sqrt((this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy));
        return this.radius >= dist + that.radius - error;
    }

    public boolean contains(double px, double py) {
        double dist = Math.sqrt((this.cx - px) * (this.cx - px) + (this.cy - py) * (this.cy - py));
        return this.radius >= dist;
    }

    public String toString() {
        return this.getClass() + "[x:" + this.cx + ",y:" + this.cy + ",r:" + this.radius + "]";
    }

    public Circle clone() {
        try {
            return (Circle)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Cloneable interface not implemented");
        }
    }
}

