/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePath2<T>
implements Serializable {
    private TreePath2<T> parentPath;
    private transient T lastPathComponent;

    public TreePath2(T[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.lastPathComponent = path[path.length - 1];
        if (path.length > 1) {
            this.parentPath = new TreePath2<T>(path, path.length - 1);
        }
    }

    public TreePath2(T singlePath) {
        if (singlePath == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.lastPathComponent = singlePath;
        this.parentPath = null;
    }

    protected TreePath2(TreePath2<T> parent, T lastElement) {
        if (lastElement == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = parent;
        this.lastPathComponent = lastElement;
    }

    protected TreePath2(T[] path, int length) {
        this.lastPathComponent = path[length - 1];
        if (length > 1) {
            this.parentPath = new TreePath2<T>(path, length - 1);
        }
    }

    protected TreePath2() {
    }

    public T[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        TreePath2<T> path = this;
        while (path != null) {
            result[i--] = path.lastPathComponent;
            path = path.parentPath;
        }
        return result;
    }

    public T getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int result = 0;
        TreePath2<T> path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public T getPathComponent(int element) {
        int pathLength = this.getPathCount();
        if (element < 0 || element >= pathLength) {
            throw new IllegalArgumentException("Index " + element + " is out of the specified range");
        }
        TreePath2<T> path = this;
        for (int i = pathLength - 1; i != element; --i) {
            path = path.parentPath;
        }
        return path.lastPathComponent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreePath2) {
            TreePath2<T> oTreePath = (TreePath2<T>)o;
            if (this.getPathCount() != oTreePath.getPathCount()) {
                return false;
            }
            TreePath2<T> path = this;
            while (path != null) {
                if (!path.lastPathComponent.equals(oTreePath.lastPathComponent)) {
                    return false;
                }
                oTreePath = oTreePath.parentPath;
                path = path.parentPath;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.lastPathComponent.hashCode();
    }

    public boolean isDescendant(TreePath2 aTreePath) {
        if (aTreePath == this) {
            return true;
        }
        if (aTreePath != null) {
            int pathLength = this.getPathCount();
            int oPathLength = aTreePath.getPathCount();
            if (oPathLength < pathLength) {
                return false;
            }
            while (oPathLength-- > pathLength) {
                aTreePath = aTreePath.getParentPath();
            }
            return this.equals(aTreePath);
        }
        return false;
    }

    public TreePath2 pathByAddingChild(T child) {
        if (child == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath2<T>(this, child);
    }

    public TreePath2 getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuffer tempSpot = new StringBuffer("[");
        int maxCounter = this.getPathCount();
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (counter > 0) {
                tempSpot.append(", ");
            }
            tempSpot.append(this.getPathComponent(counter));
        }
        tempSpot.append("]");
        return tempSpot.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Vector<String> values = new Vector<String>();
        boolean writePath = true;
        if (this.lastPathComponent != null && this.lastPathComponent instanceof Serializable) {
            values.addElement("lastPathComponent");
            values.addElement((String)this.lastPathComponent);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("lastPathComponent")) {
            this.lastPathComponent = values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }
}

