/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.tree;

import ch.randelshofer.tree.Colorizer;
import ch.randelshofer.tree.NodeInfo;
import ch.randelshofer.tree.TreeNode;
import ch.randelshofer.tree.TreePath2;
import ch.randelshofer.tree.Weighter;
import java.awt.Color;
import java.awt.Image;
import java.text.DecimalFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeInfo
implements NodeInfo {
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent;

    @Override
    public String getName(TreePath2<TreeNode> path) {
        return path.getLastPathComponent().toString();
    }

    @Override
    public Color getColor(TreePath2<TreeNode> path) {
        return Color.black;
    }

    @Override
    public long getWeight(TreePath2<TreeNode> path) {
        return 1L;
    }

    @Override
    public String getTooltip(TreePath2<TreeNode> path) {
        StringBuilder buf = new StringBuilder();
        TreePath2 parentPath = path;
        do {
            buf.insert(0, "<br>");
            buf.insert(0, this.getName(parentPath));
        } while ((parentPath = parentPath.getParentPath()) != null);
        buf.insert(0, "<html>");
        buf.append("<br>");
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node.getAllowsChildren()) {
            buf.append(DecimalFormat.getIntegerInstance().format(node.children().size()));
            buf.append(" Files");
            buf.append("<br>");
        }
        long w = this.getWeight(path);
        buf.append(DecimalFormat.getIntegerInstance().format(w));
        return buf.toString();
    }

    @Override
    public Image getImage(TreePath2<TreeNode> path) {
        return null;
    }

    @Override
    public void init(TreeNode root) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Weighter getWeighter() {
        return null;
    }

    @Override
    public Colorizer getColorizer() {
        return null;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public String getWeightFormatted(TreePath2<TreeNode> path) {
        return DecimalFormat.getIntegerInstance().format(this.getWeight(path));
    }
}

