/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BoundedRangeInputStream
extends FilterInputStream
implements BoundedRangeModel {
    private long nread = 0L;
    private long size = 0L;
    private boolean valueIsAdjusting;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();

    public BoundedRangeInputStream(InputStream in) {
        super(in);
        try {
            this.size = in.available();
        }
        catch (IOException ioe) {
            this.size = 0L;
        }
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.incrementValue(1);
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        this.incrementValue(nr);
        return nr;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        this.incrementValue(nr);
        return nr;
    }

    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        this.incrementValue((int)nr);
        return nr;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - (long)this.in.available();
        this.fireStateChanged();
    }

    private void incrementValue(int inc) {
        if (inc > 0) {
            this.nread += (long)inc;
            if (this.nread > this.size) {
                this.size = this.nread;
            }
            this.fireStateChanged();
        }
    }

    public int getMinimum() {
        return 0;
    }

    public void setMinimum(int newMinimum) {
    }

    public int getMaximum() {
        return (int)this.size;
    }

    public void setMaximum(int newMaximum) {
        this.size = newMaximum;
        this.fireStateChanged();
    }

    public int getValue() {
        return (int)this.nread;
    }

    public void setValue(int newValue) {
    }

    public void setValueIsAdjusting(boolean b) {
        this.valueIsAdjusting = b;
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public int getExtent() {
        return 0;
    }

    public void setExtent(int newExtent) {
    }

    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

