/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui;

import ch.randelshofer.gui.ProgressFrame;
import ch.randelshofer.gui.ProgressObserver;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressView
extends JPanel
implements ProgressObserver {
    private boolean isCanceled;
    private boolean isCompleted;
    private boolean isClosed;
    private boolean isCancelable = true;
    private BoundedRangeModel model;
    private Runnable doCancel;
    private ChangeListener changeHandler = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            if (ProgressView.this.model != null && ProgressView.this.model.getValue() >= ProgressView.this.model.getMaximum()) {
                ProgressView.this.complete();
            }
        }
    };
    private JButton cancelButton;
    private JButton closeButton;
    private JLabel errorLabel;
    private JLabel messageLabel;
    private JLabel noteLabel;
    private JProgressBar progressBar;
    private JSeparator separator;
    private JLabel warningLabel;

    public ProgressView(String message, String note, boolean isIndeterminate) {
        this(message, note, 0, 100, isIndeterminate);
    }

    public ProgressView(String message, String note, int min, int max) {
        this(message, note, min, max, false);
    }

    public ProgressView(final String message, final String note, final int min, final int max, final boolean isIndeterminate) {
        ProgressView.invokeAndWait(new Runnable(){

            public void run() {
                ProgressView.this.initComponents();
                ProgressView.this.setModel(new DefaultBoundedRangeModel(min, 0, min, max));
                ProgressView.this.progressBar.setIndeterminate(isIndeterminate);
                ProgressView.this.messageLabel.setText(message);
                ProgressView.this.noteLabel.setText(note);
                ProgressView.this.warningLabel.setVisible(false);
                ProgressView.this.errorLabel.setVisible(false);
                ProgressView.this.closeButton.setVisible(false);
                ProgressFrame.getInstance().addProgressView(ProgressView.this);
            }
        });
    }

    public ProgressView(String message, String note) {
        this(message, note, 0, 100, false);
    }

    public void setModel(BoundedRangeModel brm) {
        if (this.model != null) {
            this.model.removeChangeListener(this.changeHandler);
        }
        this.model = brm;
        this.progressBar.setModel(brm);
        if (this.model != null) {
            this.model.addChangeListener(this.changeHandler);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setCancelable(final boolean b) {
        this.isCancelable = b;
        ProgressView.invokeAndWait(new Runnable(){

            public void run() {
                ProgressView.this.cancelButton.setVisible(b);
                ProgressView.this.invalidate();
                ProgressView.this.validate();
            }
        });
    }

    public void setDoCancel(Runnable doCancel) {
        this.doCancel = doCancel;
    }

    public void setProgress(int nv) {
        this.model.setValue(nv);
    }

    public int getProgress() {
        return this.model.getValue();
    }

    public void complete() {
        if (!this.isCompleted) {
            this.isCompleted = true;
            this.progressBar.setValue(this.getMaximum());
            this.progressBar.setIndeterminate(false);
            this.setIndeterminate(false);
            this.cancelButton.setVisible(false);
            this.closeButton.setVisible(true);
            this.revalidate();
        }
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            ProgressFrame.getInstance().removeProgressView(this);
            if (this.model != null) {
                this.model.removeChangeListener(this.changeHandler);
            }
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int m) {
        this.model.setMinimum(m);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int m) {
        this.model.setMaximum(m);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void cancel() {
        if (this.isCancelable) {
            this.isCanceled = true;
            this.cancelButton.setEnabled(false);
            this.noteLabel.setText("Canceling...");
            if (this.doCancel != null) {
                this.doCancel.run();
            }
        } else {
            this.noteLabel.setText("This process can not be canceled!");
        }
    }

    public void setNote(String note) {
        if (!this.isCanceled) {
            this.noteLabel.setText(note);
        }
    }

    public String getNote() {
        return this.noteLabel.getText();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.warningLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.closeButton = new JButton();
        this.separator = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(this.messageLabel.getFont().getStyle() | 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.noteLabel.setFont(this.noteLabel.getFont().deriveFont((float)this.noteLabel.getFont().getSize() - 2.0f));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.noteLabel, gridBagConstraints);
        this.warningLabel.setIcon(new ImageIcon(this.getClass().getResource("/ch/randelshofer/gui/images/ProgressView.warningIcon.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.warningLabel, gridBagConstraints);
        this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/ch/randelshofer/gui/images/ProgressView.errorIcon.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.errorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.progressBar, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressView.this.cancel(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 12, 12);
        this.add((Component)this.cancelButton, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressView.this.close(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 12, 12);
        this.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.separator, gridBagConstraints);
    }

    private void close(ActionEvent evt) {
        this.close();
    }

    private void cancel(ActionEvent evt) {
        this.cancel();
    }

    public void setWarning(String message) {
        this.warningLabel.setText(message);
        if (!this.warningLabel.isVisible()) {
            ProgressView.invokeAndWait(new Runnable(){

                public void run() {
                    ProgressView.this.warningLabel.setVisible(ProgressView.this.getWarning() != null && ProgressView.this.getError() == null);
                    ProgressView.this.revalidate();
                }
            });
        }
    }

    private static void invokeAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getWarning() {
        return this.warningLabel.getText();
    }

    public void setError(String message) {
        this.errorLabel.setText(message);
        if (!this.errorLabel.isVisible()) {
            ProgressView.invokeAndWait(new Runnable(){

                public void run() {
                    ProgressView.this.warningLabel.setVisible(ProgressView.this.getWarning() != null && ProgressView.this.getError() == null);
                    ProgressView.this.errorLabel.setVisible(ProgressView.this.getError() != null);
                    ProgressView.this.revalidate();
                }
            });
        }
    }

    public String getError() {
        return this.errorLabel.getText();
    }

    public void setIndeterminate(boolean newValue) {
        this.progressBar.setIndeterminate(newValue);
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }
}

