/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui;

import ch.randelshofer.gui.ProgressObserver;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgressTracker
implements ProgressObserver {
    private String message;
    private String note;
    private String warning;
    private String error;
    private boolean isCanceled;
    private boolean isClosed;
    private boolean isCancelable = true;
    private boolean isIndeterminate;
    private boolean isCompleted;
    private BoundedRangeModel model;
    private Runnable doCancel;
    private ChangeListener changeHandler = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            if (ProgressTracker.this.model != null && ProgressTracker.this.model.getValue() >= ProgressTracker.this.model.getMaximum()) {
                ProgressTracker.this.close();
            }
        }
    };

    public ProgressTracker(String message, String note, int min, int max) {
        this.setModel(new DefaultBoundedRangeModel(min, 0, min, max));
        this.message = message;
        this.note = note;
    }

    public ProgressTracker(String message, String note) {
        this.setModel(new DefaultBoundedRangeModel(0, 0, 0, 1));
        this.message = message;
        this.note = note;
        this.isIndeterminate = true;
    }

    public void setIndeterminate(boolean newValue) {
        this.isIndeterminate = newValue;
    }

    public void setModel(BoundedRangeModel brm) {
        if (this.model != null) {
            this.model.removeChangeListener(this.changeHandler);
        }
        this.model = brm;
        if (this.model != null) {
            this.model.addChangeListener(this.changeHandler);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setCancelable(boolean b) {
        this.isCancelable = b;
    }

    public void setDoCancel(Runnable doCancel) {
        this.doCancel = doCancel;
    }

    public void setProgress(int nv) {
        this.model.setValue(nv);
    }

    public int getProgress() {
        return this.model.getValue();
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.model != null) {
                this.model.removeChangeListener(this.changeHandler);
            }
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int m) {
        this.model.setMinimum(m);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int m) {
        this.model.setMaximum(m);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void cancel() {
        if (this.isCancelable) {
            this.isCanceled = true;
            this.note = "Canceling...";
            if (this.doCancel != null) {
                this.doCancel.run();
            }
        } else {
            this.note = "This process can not be canceled!";
        }
    }

    public void setNote(String note) {
        if (!this.isCanceled) {
            this.note = note;
        }
    }

    public String getNote() {
        return this.note;
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void complete() {
        this.isCompleted = true;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setWarning(String message) {
        this.warning = message;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setError(String message) {
        this.error = message;
    }

    public String getError() {
        return this.error;
    }
}

