/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui;

import ch.randelshofer.gui.ProgressView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class ProgressFrame
extends JFrame {
    private static ProgressFrame instance;
    private JPanel progressPanel;
    private JScrollPane scrollPane;
    private JLabel infoLabel;
    private JSeparator separator;
    private JPanel strutPanel;
    private JToggleButton disclosureToggle;
    private JButton cancelAllButton;
    private JPanel viewPanel;
    private JPanel infoPanel;

    private ProgressFrame() {
        this.initComponents();
        this.setDefaultCloseOperation(1);
        this.progressPanel = new JPanel(){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 300;
                return d;
            }
        };
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
        this.scrollPane.setViewportView(this.progressPanel);
        this.disclosureToggle.setIcon(UIManager.getIcon("Tree.collapsedIcon"));
        this.disclosureToggle.setSelectedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.disclosureToggle.setUI((MetalToggleButtonUI)MetalToggleButtonUI.createUI(this.disclosureToggle));
    }

    public static ProgressFrame getInstance() {
        if (instance == null) {
            instance = new ProgressFrame();
        }
        return instance;
    }

    public void addProgressView(final ProgressView viewer) {
        ProgressFrame.invokeAndWait(new Runnable(){

            public void run() {
                ProgressFrame.this.progressPanel.add(viewer);
                ProgressFrame.this.updateInfoPanel();
                ProgressFrame.this.pack();
                if (!ProgressFrame.this.isVisible()) {
                    ProgressFrame.this.setVisible(true);
                }
                viewer.repaint();
            }
        });
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.height = Math.min(400, d.height);
        return d;
    }

    public void removeProgressView(final ProgressView viewer) {
        ProgressFrame.invokeAndWait(new Runnable(){

            public void run() {
                ProgressFrame.this.progressPanel.remove(viewer);
                ProgressFrame.this.updateInfoPanel();
                if (ProgressFrame.this.progressPanel.getComponentCount() == 0) {
                    ProgressFrame.this.setVisible(false);
                } else {
                    ProgressFrame.this.pack();
                }
            }
        });
    }

    private void updateInfoPanel() {
        int count = this.progressPanel.getComponentCount();
        switch (count) {
            case 0: {
                this.infoLabel.setText("No processes running.");
                this.cancelAllButton.setEnabled(false);
                break;
            }
            case 1: {
                this.infoLabel.setText("1 process running.");
                this.cancelAllButton.setEnabled(true);
                break;
            }
            default: {
                this.infoLabel.setText(count + " processes running.");
                this.cancelAllButton.setEnabled(true);
            }
        }
    }

    private static void invokeAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.disclosureToggle = new JToggleButton();
        this.infoLabel = new JLabel();
        this.cancelAllButton = new JButton();
        this.strutPanel = new JPanel();
        this.viewPanel = new JPanel();
        this.separator = new JSeparator();
        this.scrollPane = new JScrollPane();
        this.setTitle("Progress Monitor");
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoPanel.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.disclosureToggle.setSelected(true);
        this.disclosureToggle.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.disclosureToggle.setFocusPainted(false);
        this.disclosureToggle.setContentAreaFilled(false);
        this.disclosureToggle.setBorderPainted(false);
        this.disclosureToggle.setRequestFocusEnabled(false);
        this.disclosureToggle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ProgressFrame.this.disclosureStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.infoPanel.add((Component)this.disclosureToggle, gridBagConstraints);
        this.infoLabel.setText("No processes running.");
        this.infoLabel.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.infoLabel, gridBagConstraints);
        this.cancelAllButton.setText("Cancel All");
        this.cancelAllButton.setEnabled(false);
        this.cancelAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProgressFrame.this.cancelAll(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.infoPanel.add((Component)this.cancelAllButton, gridBagConstraints);
        this.getContentPane().add((Component)this.infoPanel, "North");
        this.strutPanel.setLayout(null);
        this.strutPanel.setPreferredSize(new Dimension(400, 0));
        this.getContentPane().add((Component)this.strutPanel, "South");
        this.viewPanel.setLayout(new BorderLayout());
        this.viewPanel.add((Component)this.separator, "North");
        this.scrollPane.setBorder(null);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.viewPanel.add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.viewPanel, "Center");
        this.pack();
    }

    private void disclosureStateChanged(ItemEvent evt) {
        this.viewPanel.setVisible(this.disclosureToggle.isSelected());
        this.pack();
    }

    private void cancelAll(ActionEvent evt) {
        Component[] components = this.progressPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProgressView)) continue;
            ((ProgressView)components[i]).cancel();
        }
    }
}

