/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.instr.InstrVisitor;
import com.vladium.emma.rt.ClassPathCacheEntry;
import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.parser.ClassDefParser;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.Files;
import com.vladium.util.IPathEnumerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ClassPathProcessorST
implements IPathEnumerator.IPathHandler,
IAppErrorCodes {
    private final File[] m_path;
    private final boolean m_canonical;
    private final IMetaData m_mdata;
    private final IInclExclFilter m_coverageFilter;
    private final InstrVisitor m_visitor;
    private final InstrVisitor.InstrResult m_instrResult;
    private final Map m_cache;
    private final Logger m_log;
    private int m_classCount;
    private byte[] m_readbuf;
    private int m_readpos;
    private ByteArrayOStream m_baos;
    private File m_archiveFile;
    private static final int BUF_SIZE = 32768;

    public void run() {
        long start = System.currentTimeMillis();
        IPathEnumerator enumerator = IPathEnumerator.Factory.create(this.m_path, this.m_canonical, this);
        this.m_readbuf = new byte[32768];
        this.m_readpos = 0;
        this.m_baos = new ByteArrayOStream(32768);
        if (this.m_log.atINFO()) {
            this.m_log.info("processing classpath ...");
        }
        try {
            enumerator.enumerate();
        }
        catch (IOException ioe) {
            throw new EMMARuntimeException("INSTR_IO_FAILURE", ioe);
        }
        if (this.m_log.atINFO()) {
            long end = System.currentTimeMillis();
            this.m_log.info("[" + this.m_classCount + " class(es) processed in " + (end - start) + " ms]");
        }
    }

    public void handleArchiveStart(File parentDir, File archive, Manifest manifest) {
        this.m_archiveFile = Files.newFile(parentDir, archive.getPath());
    }

    public void handleArchiveEntry(JarInputStream in, ZipEntry entry) {
        String name;
        String lcName;
        if (this.m_log.atTRACE2()) {
            this.m_log.trace2("handleArchiveEntry", "[" + entry.getName() + "]");
        }
        if ((lcName = (name = entry.getName()).toLowerCase()).endsWith(".class")) {
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            if (this.m_coverageFilter == null || this.m_coverageFilter.included(className)) {
                String srcURL;
                block22: {
                    srcURL = null;
                    InputStream clsin = null;
                    try {
                        this.readZipEntry(in, entry);
                        srcURL = "jar:".concat(this.m_archiveFile.toURL().toExternalForm()).concat("!/").concat(name);
                    }
                    catch (FileNotFoundException fnfe) {
                        if (clsin == null) break block22;
                        try {
                            clsin.close();
                            clsin = null;
                        }
                        catch (Exception e) {
                            throw new EMMARuntimeException(e);
                        }
                    }
                    catch (IOException ioe) {
                        throw new EMMARuntimeException(ioe);
                    }
                    finally {
                        if (clsin != null) {
                            try {
                                clsin.close();
                                clsin = null;
                            }
                            catch (Exception e) {
                                throw new EMMARuntimeException(e);
                            }
                        }
                    }
                }
                try {
                    ClassDef clsDef = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                    if (!clsDef.isInterface()) {
                        ++this.m_classCount;
                    }
                    this.m_visitor.process(clsDef, false, false, true, this.m_instrResult);
                    clsDef = null;
                    boolean cacheClassDef = true;
                    if (this.m_instrResult.m_descriptor != null && !this.m_mdata.add(this.m_instrResult.m_descriptor, false)) {
                        cacheClassDef = false;
                    }
                    if (cacheClassDef && this.m_cache != null) {
                        byte[] bytes = new byte[this.m_readpos];
                        System.arraycopy(this.m_readbuf, 0, bytes, 0, this.m_readpos);
                        this.m_cache.put(className, new ClassPathCacheEntry(bytes, srcURL));
                    }
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException(ioe);
                }
            }
        }
    }

    public void handleArchiveEnd(File parentDir, File archive) {
        this.m_archiveFile = null;
    }

    public void handleDirStart(File pathDir, File dir) {
    }

    public void handleFile(File pathDir, File file) {
        String name;
        String lcName;
        if (this.m_log.atTRACE2()) {
            this.m_log.trace2("handleFile", "[" + pathDir + "] [" + file + "]");
        }
        if ((lcName = (name = file.getPath()).toLowerCase()).endsWith(".class")) {
            String className = name.substring(0, name.length() - 6).replace(File.separatorChar, '.');
            if (this.m_coverageFilter == null || this.m_coverageFilter.included(className)) {
                String srcURL;
                block22: {
                    srcURL = null;
                    InputStream clsin = null;
                    try {
                        File inFile = Files.newFile(pathDir, file.getPath());
                        this.readFile(inFile);
                        srcURL = inFile.toURL().toExternalForm();
                    }
                    catch (FileNotFoundException fnfe) {
                        if (clsin == null) break block22;
                        try {
                            clsin.close();
                            clsin = null;
                        }
                        catch (Exception e) {
                            throw new EMMARuntimeException(e);
                        }
                    }
                    catch (IOException ioe) {
                        throw new EMMARuntimeException(ioe);
                    }
                    finally {
                        if (clsin != null) {
                            try {
                                clsin.close();
                                clsin = null;
                            }
                            catch (Exception e) {
                                throw new EMMARuntimeException(e);
                            }
                        }
                    }
                }
                try {
                    ClassDef clsDef = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                    if (!clsDef.isInterface()) {
                        ++this.m_classCount;
                    }
                    this.m_visitor.process(clsDef, false, false, true, this.m_instrResult);
                    clsDef = null;
                    boolean cacheClassDef = true;
                    if (this.m_instrResult.m_descriptor != null && !this.m_mdata.add(this.m_instrResult.m_descriptor, false)) {
                        cacheClassDef = false;
                    }
                    if (cacheClassDef && this.m_cache != null) {
                        byte[] bytes = new byte[this.m_readpos];
                        System.arraycopy(this.m_readbuf, 0, bytes, 0, this.m_readpos);
                        this.m_cache.put(className, new ClassPathCacheEntry(bytes, srcURL));
                    }
                }
                catch (IOException ioe) {
                    throw new EMMARuntimeException(ioe);
                }
            }
        }
    }

    public void handleDirEnd(File pathDir, File dir) {
    }

    ClassPathProcessorST(File[] path, boolean canonical, IMetaData mdata, IInclExclFilter filter, Map cache) {
        if (path == null) {
            throw new IllegalArgumentException("null input: path");
        }
        if (mdata == null) {
            throw new IllegalArgumentException("null input: mdata");
        }
        this.m_path = path;
        this.m_canonical = canonical;
        this.m_mdata = mdata;
        this.m_coverageFilter = filter;
        this.m_cache = cache;
        this.m_visitor = new InstrVisitor(mdata.getOptions());
        this.m_instrResult = new InstrVisitor.InstrResult();
        this.m_log = Logger.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File file) throws IOException {
        int length = (int)file.length();
        this.ensureReadCapacity(length);
        FileInputStream in = null;
        try {
            int totalread;
            int read;
            in = new FileInputStream(file);
            for (totalread = 0; totalread < length && (read = ((InputStream)in).read(this.m_readbuf, totalread, length - totalread)) >= 0; totalread += read) {
            }
            this.m_readpos = totalread;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private void readZipEntry(ZipInputStream in, ZipEntry entry) throws IOException {
        int length = (int)entry.getSize();
        if (length >= 0) {
            int totalread;
            int read;
            this.ensureReadCapacity(length);
            for (totalread = 0; totalread < length && (read = in.read(this.m_readbuf, totalread, length - totalread)) >= 0; totalread += read) {
            }
            this.m_readpos = totalread;
        } else {
            int read;
            this.ensureReadCapacity(32768);
            this.m_baos.reset();
            while ((read = in.read(this.m_readbuf)) >= 0) {
                this.m_baos.write(this.m_readbuf, 0, read);
            }
            this.m_readbuf = this.m_baos.copyByteArray();
            this.m_readpos = this.m_readbuf.length;
        }
    }

    private void ensureReadCapacity(int capacity) {
        if (this.m_readbuf.length < capacity) {
            int readbuflen = this.m_readbuf.length;
            this.m_readbuf = null;
            this.m_readbuf = new byte[Math.max(readbuflen << 1, capacity)];
        }
    }
}

