/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.ow2.dsrg.fm.tbplib.TBPLibLog;
import org.ow2.dsrg.fm.tbplib.architecture.Architecture;
import org.ow2.dsrg.fm.tbplib.architecture.Component;
import org.ow2.dsrg.fm.tbplib.architecture.Interface;
import org.ow2.dsrg.fm.tbplib.architecture.Method;
import org.ow2.dsrg.fm.tbplib.event.EventTable;
import org.ow2.dsrg.fm.tbplib.event.EventTableImpl;
import org.ow2.dsrg.fm.tbplib.ltsa.CompactDFA;
import org.ow2.dsrg.fm.tbplib.ltsa.DynamicDFA;
import org.ow2.dsrg.fm.tbplib.ltsa.DynamicNFA;
import org.ow2.dsrg.fm.tbplib.ltsa.Observer;
import org.ow2.dsrg.fm.tbplib.node.TBPComposition;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPSpecification;
import org.ow2.dsrg.fm.tbplib.node.visitor.PrintComponentVisitor;
import org.ow2.dsrg.fm.tbplib.node.visitor.SymbolCollectingVisitor;
import org.ow2.dsrg.fm.tbplib.node.visitor.TranslateProvisionVisitor;
import org.ow2.dsrg.fm.tbplib.parser.ParserFacade;
import org.ow2.dsrg.fm.tbplib.reference.EnumerationType;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;
import org.ow2.dsrg.fm.tbplib.reference.Reference;
import org.ow2.dsrg.fm.tbplib.reference.ReferenceResolver;
import org.ow2.dsrg.fm.tbplib.util.CodeWriter;

public class TransformationChain {
    public static List<TBPSpecification<String>> parseFiles(Architecture arch, String ... files) throws IOException, RecognitionException {
        ArrayList<TBPSpecification<String>> tbps = new ArrayList<TBPSpecification<String>>(files.length);
        for (String filename : files) {
            TBPLibLog.logger.info("Parsing file: \"" + filename + "\"");
            TBPSpecification<String> tbp = ParserFacade.parseFile(filename, arch);
            tbps.add(tbp);
        }
        return tbps;
    }

    public static void renameBoundInterfaces(Architecture architecture) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static List<TBPSpecification<Reference>> resolveArchitecture(List<TBPSpecification<String>> tbps, Architecture architecture) {
        ReferenceResolver resolver = new ReferenceResolver(architecture);
        List<Component> comps = architecture.getComponents();
        ArrayList<TBPSpecification<Reference>> result = new ArrayList<TBPSpecification<Reference>>(tbps.size());
        assert (comps.size() == tbps.size());
        for (int i = 0; i < tbps.size(); ++i) {
            TBPSpecification<String> tbp = tbps.get(i);
            Component comp = comps.get(i);
            resolver.enterComponent(comp);
            result.add(tbp.resolve(resolver));
            resolver.leaveComponent();
        }
        return result;
    }

    public static void collectSymbolsFromArchitecture(List<TBPSpecification<String>> tbps, Architecture architecture) {
        List<Component> comps = architecture.getComponents();
        SymbolCollectingVisitor visitor = new SymbolCollectingVisitor(architecture);
        assert (comps.size() == tbps.size());
        for (int i = 0; i < tbps.size(); ++i) {
            TBPSpecification<String> tbp = tbps.get(i);
            Component comp = comps.get(i);
            visitor.setComponent(comp);
            tbp.visit(visitor);
        }
    }

    public static TBPSpecification<Reference> resolveTBP(TBPSpecification<String> tbp, Component component) {
        ReferenceResolver resolver = new ReferenceResolver(component.getParent());
        resolver.enterComponent(component);
        return tbp.resolve(resolver);
    }

    public static void performSemanticCheck(List<TBPSpecification<Reference>> tbps, Architecture architecture) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public static void performImplicitBinding(Architecture architecture) {
        for (Component comp : architecture.getComponents()) {
            LinkedHashMap<String, Interface> provided = comp.getProvidedInterfaces();
            for (Component c2 : architecture.getComponents()) {
                for (Interface iface : c2.getRequiredInterfaces().values()) {
                    Interface target;
                    if (iface.isBound() || (target = (Interface)provided.get(iface.getName())) == null) continue;
                    iface.bindTo(target);
                }
            }
        }
    }

    public static <REFERENCE> TBPSpecification<REFERENCE> performComposition(List<TBPSpecification<REFERENCE>> tbps, REFERENCE name) {
        TBPComposition<REFERENCE> tbpComp = new TBPComposition<REFERENCE>();
        tbpComp.addMultipleTBP(tbps);
        return tbpComp.getComposition(name);
    }

    public static <REFERENCE> void printTBP(CodeWriter output, TBPSpecification<REFERENCE> tbp, Component component) {
        PrintComponentVisitor<REFERENCE> visitor = new PrintComponentVisitor<REFERENCE>(output);
        visitor.printComponentSpecification(tbp, component);
        output.flush();
    }

    public static void fillEventTable(Architecture arch, EventTable eventTable) {
        for (Component c : arch.getComponents()) {
            for (Interface iface : c.getProvidedInterfaces().values()) {
                for (Method method : iface.getMethods().values()) {
                    MethodSignature<Reference> sig = method.getMethodSignature();
                    EnumerationType retType = (EnumerationType)sig.getReturnType();
                    int retDomain = retType == null ? 0 : retType.getEnums().size();
                    LinkedHashMap<Reference, Reference> params = sig.getParams();
                    int[] parDomains = new int[params.size()];
                    int i = 0;
                    for (Reference ref : params.values()) {
                        parDomains[i] = ((EnumerationType)ref).getEnums().size();
                        ++i;
                    }
                    eventTable.addMethodEncoder(new EventTableImpl.MethodEncoderImpl(method.getFullname(), retDomain, parDomains));
                }
            }
        }
    }

    public static <REFERENCE extends Reference> Observer transformProvision(TBPProvisionContainerNode<REFERENCE> provision, EventTable eventTable) {
        TranslateProvisionVisitor visitor = new TranslateProvisionVisitor(eventTable);
        DynamicNFA nfa = (DynamicNFA)provision.visit(visitor);
        DynamicDFA dfa = nfa.determinize();
        nfa = null;
        dfa = dfa.makeMinimal();
        HashSet<Integer> filter = new HashSet<Integer>();
        for (Reference ref : provision.getFilter()) {
            filter.add(eventTable.encodeMethod(((Method)ref).getFullname()));
        }
        return CompactDFA.makeCompact(dfa, eventTable, filter);
    }

    public static <REFERENCE extends Reference> List<Observer> transformProvisions(List<TBPSpecification<REFERENCE>> tbps, EventTable eventTable) {
        ArrayList<Observer> dfas = new ArrayList<Observer>();
        for (TBPSpecification<REFERENCE> tbp : tbps) {
            for (TBPProvisionContainerNode<REFERENCE> provision : tbp.getProvisions()) {
                dfas.add(TransformationChain.transformProvision(provision, eventTable));
            }
        }
        return dfas;
    }
}

