/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class CodeWriter
extends PrintWriter {
    private int currentIndent = 0;
    private int indentStep = 4;
    private char indentChar = (char)32;
    private String indentString = "";
    private boolean needsIndent = true;

    public CodeWriter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, csn);
    }

    public CodeWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public CodeWriter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileName, csn);
    }

    public CodeWriter(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public CodeWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public CodeWriter(OutputStream out) {
        super(out);
    }

    public CodeWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public CodeWriter(Writer out) {
        super(out);
    }

    public CodeWriter(File file, String csn, int indentStep, char indentChar) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, csn);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public CodeWriter(File file, int indentStep, char indentChar) throws FileNotFoundException {
        super(file);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public CodeWriter(String fileName, String csn, int indentStep, char indentChar) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileName, csn);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public CodeWriter(String fileName, int indentStep, char indentChar) throws FileNotFoundException {
        super(fileName);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public CodeWriter(OutputStream out, boolean autoFlush, int indentStep, char indentChar) {
        super(out, autoFlush);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public CodeWriter(OutputStream out, int indentStep, char indentChar) {
        super(out);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public CodeWriter(Writer out, boolean autoFlush, int indentStep, char indentChar) {
        super(out, autoFlush);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public CodeWriter(Writer out, int indentStep, char indentChar) {
        super(out);
        this.indentStep = indentStep;
        this.indentChar = indentChar;
    }

    public void increaseIndent() {
        ++this.currentIndent;
        this.updateIndentString();
    }

    public void decreaseIndent() {
        assert (this.currentIndent > 0);
        --this.currentIndent;
        this.updateIndentString();
    }

    private void updateIndentString() {
        StringBuilder bfr = new StringBuilder(this.indentStep * this.currentIndent);
        for (int i = 0; i < this.indentStep * this.currentIndent; ++i) {
            bfr.append(this.indentChar);
        }
        this.indentString = bfr.toString();
    }

    @Override
    public void println() {
        super.println();
        this.needsIndent = true;
    }

    @Override
    public void write(int c) {
        if (this.needsIndent && this.currentIndent != 0) {
            super.write(this.indentString, 0, this.indentString.length());
            this.needsIndent = false;
        }
        super.write(c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        if (this.needsIndent && this.currentIndent != 0) {
            super.write(this.indentString, 0, this.indentString.length());
            this.needsIndent = false;
        }
        super.write(buf, off, len);
    }

    @Override
    public void write(char[] buf) {
        if (this.needsIndent && this.currentIndent != 0) {
            super.write(this.indentString, 0, this.indentString.length());
            this.needsIndent = false;
        }
        super.write(buf);
    }

    @Override
    public void write(String s, int off, int len) {
        if (this.needsIndent && this.currentIndent != 0) {
            super.write(this.indentString, 0, this.indentString.length());
            this.needsIndent = false;
        }
        super.write(s, off, len);
    }

    @Override
    public void write(String s) {
        if (this.needsIndent && this.currentIndent != 0) {
            super.write(this.indentString, 0, this.indentString.length());
            this.needsIndent = false;
        }
        super.write(s);
    }
}

