/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.reference;

import java.util.ArrayList;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.architecture.Architecture;
import org.ow2.dsrg.fm.tbplib.architecture.Autonomous;
import org.ow2.dsrg.fm.tbplib.architecture.Component;
import org.ow2.dsrg.fm.tbplib.architecture.Interface;
import org.ow2.dsrg.fm.tbplib.architecture.Method;
import org.ow2.dsrg.fm.tbplib.reference.Constant;
import org.ow2.dsrg.fm.tbplib.reference.EnumerationType;
import org.ow2.dsrg.fm.tbplib.reference.MethodCall;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;
import org.ow2.dsrg.fm.tbplib.reference.Reference;
import org.ow2.dsrg.fm.tbplib.reference.ReferenceTransformer;
import org.ow2.dsrg.fm.tbplib.reference.Variable;

public class ReferenceResolver
implements ReferenceTransformer<String, Reference> {
    protected Architecture architecture;
    protected Component component;
    protected Method method;
    protected Autonomous thread;

    public ReferenceResolver(Architecture architecture) {
        this.architecture = architecture;
    }

    @Override
    public void enterComponent(Component component) {
        this.component = component;
        this.method = null;
        this.thread = null;
    }

    @Override
    public void leaveComponent() {
        this.component = null;
        this.method = null;
        this.thread = null;
    }

    @Override
    public void enterMethod(Reference method) {
        this.method = (Method)method;
        this.thread = null;
    }

    @Override
    public void leaveMethod() {
        this.method = null;
        this.thread = null;
    }

    @Override
    public void enterThread(Reference thread) {
        this.method = null;
        this.thread = (Autonomous)thread;
    }

    @Override
    public void leaveThread() {
        this.method = null;
        this.thread = null;
    }

    @Override
    public MethodSignature<Reference> resolveMethodSignature(MethodSignature<String> methodSignature, Reference method) {
        Method m = (Method)method;
        MethodSignature<Reference> ms = m.getMethodSignature();
        assert (ms != null);
        return ms;
    }

    @Override
    public MethodCall<Reference> resolveMethodCall(MethodCall<String> methodCall, boolean remote) {
        Method targetMethod;
        Interface targetIface;
        Interface localIface = remote ? this.component.getRequiredInterfaces().get(methodCall.getInterface()) : this.component.getProvidedInterfaces().get(methodCall.getInterface());
        assert (localIface != null);
        Method localMethod = (Method)localIface.findSymbol(methodCall.getMethod());
        assert (localMethod != null);
        if (remote && !localIface.isBound()) {
            throw new UnsupportedOperationException("Cannot resolve unbound interface (yet to be implemented): " + localIface.getName());
        }
        if (remote) {
            targetIface = localIface.getBoundInterface();
            targetMethod = (Method)targetIface.findSymbol(methodCall.getMethod());
        } else {
            targetIface = localIface;
            targetMethod = localMethod;
        }
        List<String> oldParams = methodCall.getParamDecl();
        ArrayList<Reference> newParams = new ArrayList<Reference>(oldParams.size());
        for (String par : oldParams) {
            newParams.add(this.resolveIdentifier(par));
        }
        MethodCall<Reference> newMethodCall = new MethodCall<Reference>(targetIface, targetMethod, newParams);
        return newMethodCall;
    }

    @Override
    public Reference resolveIdentifier(String identifier) {
        Variable var = null;
        if (this.method != null) {
            var = this.method.getLocals().get(identifier);
            if (var != null) {
                return var;
            }
            var = this.method.getParameters().get(identifier);
        } else if (this.thread != null) {
            var = this.thread.getLocals().get(identifier);
        }
        if (var != null) {
            return var;
        }
        var = this.component.getStateVariables().get(identifier);
        if (var != null) {
            return var;
        }
        for (EnumerationType type : this.architecture.getTypes().values()) {
            Constant c = type.getEnums().get(identifier);
            if (c == null) continue;
            return c;
        }
        throw new TBPResolvingException("Undefined identifier: " + identifier);
    }

    @Override
    public Reference resolveComponent(String identifier) {
        for (Component comp : this.architecture.getComponents()) {
            if (!comp.getName().equals(identifier)) continue;
            return comp;
        }
        throw new TBPResolvingException("Undefined component: " + identifier);
    }

    @Override
    public Reference resolveInterface(String identifier) {
        Interface iface = this.component.getProvidedInterfaces().get(identifier);
        if (iface == null) {
            throw new TBPResolvingException("Undefined provided interface: " + identifier);
        }
        return iface;
    }

    @Override
    public Reference resolveMethod(String identifier, Reference iface) {
        Interface i = (Interface)iface;
        Method m = (Method)i.findSymbol(identifier);
        if (m == null) {
            throw new TBPResolvingException("Method '" + identifier + "' not found in the interface: " + identifier);
        }
        return m;
    }

    @Override
    public Reference resolveThread(String identifier) {
        Autonomous t = this.component.getThreads().get(identifier);
        if (t == null) {
            throw new TBPResolvingException("Undefined thread: " + identifier);
        }
        return t;
    }

    @Override
    public Reference resolveVariable(String identifier) {
        Variable var = this.method != null ? (Variable)this.method.getLocals().get(identifier) : (this.thread != null ? (Variable)this.thread.getLocals().get(identifier) : (Variable)this.component.getStateVariables().get(identifier));
        if (var == null) {
            throw new TBPResolvingException("Undefined variable: " + identifier);
        }
        return var;
    }

    @Override
    public Reference resolveType(String identifier) {
        EnumerationType type = this.architecture.getTypes().get(identifier);
        if (type == null) {
            throw new TBPResolvingException("Undefined type: " + identifier);
        }
        return type;
    }

    @Override
    public Reference resolveConstant(String identifier, Reference type) {
        EnumerationType realType = (EnumerationType)type;
        Constant c = realType.getEnums().get(identifier);
        if (c == null) {
            throw new TBPResolvingException("Identifier '" + identifier + "' is not member of the type: " + realType.getName());
        }
        return c;
    }
}

