/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.reference;

import java.util.List;

public class MethodCall<REFERENCE> {
    private REFERENCE ifaceName;
    private REFERENCE methodName;
    private String fullname;
    private List<REFERENCE> paramDecl;

    public MethodCall(REFERENCE ifaceName, REFERENCE methodName, List<REFERENCE> paramDecl) {
        this.ifaceName = ifaceName;
        this.methodName = methodName;
        this.paramDecl = paramDecl;
        this.recompute_fullname();
    }

    public List<REFERENCE> getParamDecl() {
        return this.paramDecl;
    }

    public REFERENCE getInterface() {
        return this.ifaceName;
    }

    public void setInterface(REFERENCE ifaceName) {
        this.ifaceName = ifaceName;
        this.recompute_fullname();
    }

    public REFERENCE getMethod() {
        return this.methodName;
    }

    public void setMethod(REFERENCE methodName) {
        this.methodName = methodName;
        this.recompute_fullname();
    }

    public String getFullname() {
        return this.fullname;
    }

    public MethodCall clone() {
        try {
            return (MethodCall)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private void recompute_fullname() {
        this.fullname = this.ifaceName.toString() + "." + this.methodName.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFullname());
        sb.append('(');
        boolean first = true;
        for (REFERENCE par : this.getParamDecl()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(par);
            first = false;
        }
        sb.append(')');
        return sb.toString();
    }
}

