/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.reference;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.reference.Constant;
import org.ow2.dsrg.fm.tbplib.reference.Reference;

public class EnumerationType
implements Reference {
    private static final String UNLOCKED_STR = "UNLOCKED";
    private static final String LOCKED_STR = "LOCKED";
    public static final EnumerationType MUTEX_TYPE = new EnumerationType("__MUTEX", Arrays.asList("UNLOCKED", "LOCKED"));
    public static final Constant UNLOCKED = MUTEX_TYPE.getEnums().get("UNLOCKED");
    public static final Constant LOCKED = MUTEX_TYPE.getEnums().get("LOCKED");
    protected final Map<String, Constant> enums;
    private final String name;

    protected EnumerationType(String name) {
        this.name = name;
        this.enums = new HashMap<String, Constant>();
    }

    public EnumerationType(String name, Collection<String> enums) {
        this.enums = new HashMap<String, Constant>(enums.size());
        for (String item : enums) {
            Constant c = new Constant(this, item, enums.size());
            if (this.enums.containsKey(item)) {
                throw new TBPResolvingException("Duplicate constant '" + c.getName() + "' in the type: " + name);
            }
            this.enums.put(item, c);
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, Constant> getEnums() {
        return this.enums;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumerationType)) {
            return false;
        }
        EnumerationType other = (EnumerationType)obj;
        if (!((Object)this.enums).equals(other.enums)) {
            return false;
        }
        return this.name.equals(other.name);
    }
}

