/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node.visitor;

import java.util.LinkedHashMap;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.architecture.Method;
import org.ow2.dsrg.fm.tbplib.event.EventTable;
import org.ow2.dsrg.fm.tbplib.ltsa.DynamicNFA;
import org.ow2.dsrg.fm.tbplib.node.TBPAccept;
import org.ow2.dsrg.fm.tbplib.node.TBPAlternative;
import org.ow2.dsrg.fm.tbplib.node.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPParallel;
import org.ow2.dsrg.fm.tbplib.node.TBPParallelOr;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNull;
import org.ow2.dsrg.fm.tbplib.node.TBPRepetition;
import org.ow2.dsrg.fm.tbplib.node.TBPSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPCheckingVisitor;
import org.ow2.dsrg.fm.tbplib.reference.Constant;
import org.ow2.dsrg.fm.tbplib.reference.EnumerationType;
import org.ow2.dsrg.fm.tbplib.reference.MethodCall;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;
import org.ow2.dsrg.fm.tbplib.reference.Reference;

public class TranslateProvisionVisitor<REFERENCE extends Reference>
extends TBPCheckingVisitor<DynamicNFA, REFERENCE> {
    private EventTable eventTable;

    public TranslateProvisionVisitor(EventTable eventTable) {
        this.eventTable = eventTable;
    }

    @Override
    public DynamicNFA visitParsedAlternative(TBPAlternative<REFERENCE> node) {
        return ((DynamicNFA)node.getLeft().visit(this)).addAlternative((DynamicNFA)node.getRight().visit(this));
    }

    @Override
    public DynamicNFA visitParsedParallel(TBPParallel<REFERENCE> node) {
        return ((DynamicNFA)node.getLeft().visit(this)).addParallel((DynamicNFA)node.getRight().visit(this));
    }

    @Override
    public DynamicNFA visitParsedParallelOr(TBPParallelOr<REFERENCE> node) {
        return ((DynamicNFA)node.getLeft().visit(this)).addParallelOr((DynamicNFA)node.getRight().visit(this));
    }

    @Override
    public DynamicNFA visitParsedSequence(TBPSequence<REFERENCE> node) {
        return ((DynamicNFA)node.getLeft().visit(this)).addSequence((DynamicNFA)node.getRight().visit(this));
    }

    @Override
    public DynamicNFA visitParsedAccept(TBPAccept<REFERENCE> node) {
        long code;
        MethodCall<REFERENCE> mc = node.getMethodCall();
        MethodSignature<Reference> sig = ((Method)mc.getMethod()).getMethodSignature();
        LinkedHashMap<Reference, Reference> paramsDecl = sig.getParams();
        List<REFERENCE> params = mc.getParamDecl();
        int methodCode = this.eventTable.encodeMethod(mc.getFullname());
        DynamicNFA result = new DynamicNFA();
        int startState = result.allocateState();
        int middleState = result.allocateState();
        int endState = result.allocateState();
        result.setInitial(startState);
        result.markFinal(endState);
        if (paramsDecl.size() == 0) {
            code = this.eventTable.encodeMethodCall(methodCode, new int[0]);
            result.addEdge(startState, code, middleState);
        } else {
            boolean carry;
            int i = 0;
            int[] doms = new int[paramsDecl.size()];
            int[] codes = new int[paramsDecl.size()];
            for (Reference type : sig.getParams().values()) {
                doms[i++] = ((EnumerationType)type).getEnums().size();
            }
            i = 0;
            for (Reference val : params) {
                if (val == null) {
                    codes[i] = 0;
                } else {
                    doms[i] = 0;
                    codes[i] = ((Constant)val).getCode();
                }
                ++i;
            }
            block2: do {
                long code2 = this.eventTable.encodeMethodCall(methodCode, codes);
                carry = true;
                result.addEdge(startState, code2, middleState);
                for (i = 0; i < codes.length; ++i) {
                    if (doms[i] == 0) continue;
                    if (codes[i] + 1 < doms[i]) {
                        int n = i;
                        codes[n] = codes[n] + 1;
                        carry = false;
                        continue block2;
                    }
                    codes[i] = 0;
                }
            } while (!carry);
        }
        if (node.getReturnValue() != null || sig.getReturnType() == null) {
            code = this.eventTable.encodeMethodReturn(methodCode, node.getReturnValue() == null ? -1 : ((Constant)node.getReturnValue()).getCode());
            result.addEdge(middleState, code, endState);
        } else {
            for (int i = 0; i < ((EnumerationType)sig.getReturnType()).getEnums().size(); ++i) {
                long code3 = this.eventTable.encodeMethodReturn(methodCode, i);
                result.addEdge(middleState, code3, endState);
            }
        }
        return result;
    }

    @Override
    public DynamicNFA visitParsedNull(TBPProvisionNull<REFERENCE> node) {
        return DynamicNFA.createNull();
    }

    @Override
    public DynamicNFA visitLimitedReentrancy(TBPLimitedReentrancy<REFERENCE> node) {
        return ((DynamicNFA)node.getChild().visit(this)).addLimitedReentrancy(node.getLimit());
    }

    @Override
    public DynamicNFA visitParsedRepetition(TBPRepetition<REFERENCE> node) {
        return ((DynamicNFA)node.getChild().visit(this)).addRepetition();
    }

    @Override
    public DynamicNFA visitUnlimitedReentrancy(TBPUnlimitedReentrancy<REFERENCE> node) {
        throw new UnsupportedOperationException("UnlimitedReentrancy cannot be translated into DFA.");
    }

    @Override
    public DynamicNFA visitParsedProvisionContainerNode(TBPProvisionContainerNode<REFERENCE> node) {
        return (DynamicNFA)node.getChild().visit(this);
    }
}

