/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node.visitor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.architecture.Architecture;
import org.ow2.dsrg.fm.tbplib.architecture.Autonomous;
import org.ow2.dsrg.fm.tbplib.architecture.Component;
import org.ow2.dsrg.fm.tbplib.architecture.Interface;
import org.ow2.dsrg.fm.tbplib.architecture.Method;
import org.ow2.dsrg.fm.tbplib.node.TBPAccept;
import org.ow2.dsrg.fm.tbplib.node.TBPAlternative;
import org.ow2.dsrg.fm.tbplib.node.TBPAssignment;
import org.ow2.dsrg.fm.tbplib.node.TBPEmit;
import org.ow2.dsrg.fm.tbplib.node.TBPIf;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNull;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.node.TBPNode;
import org.ow2.dsrg.fm.tbplib.node.TBPParallel;
import org.ow2.dsrg.fm.tbplib.node.TBPParallelOr;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNull;
import org.ow2.dsrg.fm.tbplib.node.TBPRepetition;
import org.ow2.dsrg.fm.tbplib.node.TBPReturn;
import org.ow2.dsrg.fm.tbplib.node.TBPSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPSpecification;
import org.ow2.dsrg.fm.tbplib.node.TBPSwitch;
import org.ow2.dsrg.fm.tbplib.node.TBPSync;
import org.ow2.dsrg.fm.tbplib.node.TBPThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPValue;
import org.ow2.dsrg.fm.tbplib.node.TBPVariableDefinition;
import org.ow2.dsrg.fm.tbplib.node.TBPWhile;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPCheckingVisitor;
import org.ow2.dsrg.fm.tbplib.reference.Constant;
import org.ow2.dsrg.fm.tbplib.reference.EnumerationType;
import org.ow2.dsrg.fm.tbplib.reference.LocalVariable;
import org.ow2.dsrg.fm.tbplib.reference.MethodCall;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;
import org.ow2.dsrg.fm.tbplib.reference.Parameter;
import org.ow2.dsrg.fm.tbplib.reference.Reference;
import org.ow2.dsrg.fm.tbplib.reference.StateVariable;

public class SymbolCollectingVisitor
extends TBPCheckingVisitor<Object, String> {
    protected Architecture architecture;
    protected Component component;
    protected Method method;
    protected Autonomous thread;

    public SymbolCollectingVisitor(Architecture architecture) {
        this.architecture = architecture;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Override
    public Object visitParsedImperativeSequence(TBPImperativeSequence<String> node) {
        node.getLeft().visit(this);
        node.getRight().visit(this);
        return null;
    }

    @Override
    public Object visitVariableDefinition(TBPVariableDefinition<String> node) {
        Constant init;
        EnumerationType type;
        if (this.method != null) {
            EnumerationType type2 = this.findType(node.getTypename());
            Constant init2 = type2.getEnums().get(node.getInitialValue());
            if (init2 == null) {
                throw new TBPResolvingException("Initial value '" + node.getInitialValue() + "' is not element of the type of the local variable: " + node.getName());
            }
            this.method.addLocalVariable(new LocalVariable(this.method, type2, node.getName(), init2));
            return null;
        }
        if (this.thread != null) {
            EnumerationType type3 = this.findType(node.getTypename());
            Constant init3 = type3.getEnums().get(node.getInitialValue());
            if (init3 == null) {
                throw new TBPResolvingException("Initial value '" + node.getInitialValue() + "' is not element of the type of the local variable: " + node.getName());
            }
            this.thread.addLocalVariable(new LocalVariable(this.thread, type3, node.getName(), init3));
            return null;
        }
        if (node.isMutex()) {
            type = EnumerationType.MUTEX_TYPE;
            init = EnumerationType.UNLOCKED;
        } else {
            type = this.findType(node.getTypename());
            init = type.getEnums().get(node.getInitialValue());
        }
        if (init == null) {
            throw new TBPResolvingException("Initial value '" + node.getInitialValue() + "' is not element of the type of the state variable: " + node.getName());
        }
        this.component.addStateVariable(new StateVariable(type, node.getName(), init, this.component));
        return null;
    }

    @Override
    public Object visitParsedSwitch(TBPSwitch<String> node) {
        for (TBPNode<String> tBPNode : node.getChildren()) {
            tBPNode.visit(this);
        }
        if (node.isDeterministic()) {
            node.getValue().visit(this);
        }
        return null;
    }

    @Override
    public Object visitParsedIf(TBPIf<String> node) {
        node.getChild(0).visit(this);
        if (node.hasElse()) {
            node.getChild(1).visit(this);
        }
        return null;
    }

    @Override
    public Object visitParsedValue(TBPValue<String> node) {
        if (node.isMethodCall()) {
            this.prepareMethod(node.getMethodCall());
        }
        return null;
    }

    @Override
    public Object visitParsedReturn(TBPReturn<String> node) {
        return null;
    }

    @Override
    public Object visitParsedWhile(TBPWhile<String> node) {
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitParsedAssignment(TBPAssignment<String> node) {
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitParsedMethodDeclaration(TBPMethodDeclaration<String> node) {
        Interface iface = this.component.getProvidedInterfaces().get(node.getInterface());
        if (iface == null) {
            iface = new Interface(node.getInterface(), this.component, Interface.Direction.PROVIDED);
            this.component.addProvidedInterface(iface);
        }
        if (iface.containsSymbol(node.getMethod())) {
            throw new TBPResolvingException("Symbol conflict: " + node.getMethod());
        }
        this.method = new Method(iface, node.getMethod());
        iface.addMethod(this.method);
        MethodSignature<String> oldSignature = node.getSignature();
        EnumerationType returnType = this.findType(oldSignature.getReturnType());
        LinkedHashMap<String, String> oldParams = oldSignature.getParams();
        ArrayList<Parameter> newParamList = new ArrayList<Parameter>(oldParams.size());
        LinkedHashMap<Parameter, EnumerationType> newParams = new LinkedHashMap<Parameter, EnumerationType>();
        for (String param : oldParams.keySet()) {
            EnumerationType type = this.findType(oldParams.get(param));
            Parameter parameter = new Parameter(this.method, type, param);
            newParamList.add(parameter);
            newParams.put(parameter, type);
        }
        MethodSignature<Reference> newSignature = new MethodSignature<Reference>(newParams, returnType);
        this.method.setMethodSignature(newSignature);
        this.method.setParameters(newParamList);
        List localVars = node.getLocalVariables();
        for (TBPVariableDefinition<String> tBPVariableDefinition : localVars) {
            tBPVariableDefinition.visit(this);
        }
        node.getChild().visit(this);
        this.method = null;
        return null;
    }

    @Override
    public Object visitParsedSync(TBPSync<String> node) {
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitParsedImperativeNull(TBPImperativeNull<String> node) {
        return null;
    }

    @Override
    public Object visitParsedEmit(TBPEmit<String> node) {
        this.prepareMethod(node.getMethodCall());
        return null;
    }

    @Override
    public Object visitParsedProvisionContainerNode(TBPProvisionContainerNode<String> node) {
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitLimitedReentrancy(TBPLimitedReentrancy<String> node) {
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitParsedAccept(TBPAccept<String> node) {
        Interface iface = this.component.getProvidedInterfaces().get(node.getInterface());
        if (iface == null) {
            throw new TBPResolvingException("Undefined provided interface used in provisions: " + node.getInterface());
        }
        if (!iface.containsSymbol(node.getMethod())) {
            throw new TBPResolvingException("Undefined method of a provided interface used in provisions: " + node.getFullname());
        }
        return null;
    }

    @Override
    public Object visitParsedAlternative(TBPAlternative<String> node) {
        node.getLeft().visit(this);
        node.getRight().visit(this);
        return null;
    }

    @Override
    public Object visitParsedNull(TBPProvisionNull<String> node) {
        return null;
    }

    @Override
    public Object visitParsedParallel(TBPParallel<String> node) {
        node.getLeft().visit(this);
        node.getRight().visit(this);
        return null;
    }

    @Override
    public Object visitParsedParallelOr(TBPParallelOr<String> node) {
        node.getLeft().visit(this);
        node.getRight().visit(this);
        return null;
    }

    @Override
    public Object visitParsedRepetition(TBPRepetition<String> node) {
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitParsedSequence(TBPSequence<String> node) {
        node.getLeft().visit(this);
        node.getRight().visit(this);
        return null;
    }

    @Override
    public Object visitUnlimitedReentrancy(TBPUnlimitedReentrancy<String> node) {
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitParsedThreadContainerNode(TBPThreadContainerNode<String> node) {
        this.thread = new Autonomous(node.getName());
        this.component.addThread(this.thread);
        List localVars = node.getLocalVariables();
        for (TBPVariableDefinition<String> tBPVariableDefinition : localVars) {
            tBPVariableDefinition.visit(this);
        }
        node.getChild().visit(this);
        this.thread = null;
        return null;
    }

    @Override
    public Object visitSpecification(TBPSpecification<String> node) {
        for (TBPMethodDeclaration<String> tBPMethodDeclaration : node.getReactions()) {
            tBPMethodDeclaration.visit(this);
        }
        for (TBPThreadContainerNode tBPThreadContainerNode : node.getThreads()) {
            tBPThreadContainerNode.visit(this);
        }
        for (TBPVariableDefinition tBPVariableDefinition : node.getVariables()) {
            tBPVariableDefinition.visit(this);
        }
        for (TBPProvisionContainerNode tBPProvisionContainerNode : node.getProvisions()) {
            tBPProvisionContainerNode.visit(this);
        }
        return null;
    }

    private EnumerationType findType(String typeName) {
        if (typeName == null) {
            return null;
        }
        EnumerationType type = this.architecture.getTypes().get(typeName);
        if (type == null) {
            throw new TBPResolvingException("Undefined type: " + typeName);
        }
        return type;
    }

    private void prepareMethod(MethodCall<String> mc) {
        Interface iface = this.component.getRequiredInterfaces().get(mc.getInterface());
        if (iface == null) {
            iface = new Interface(mc.getInterface(), this.component, Interface.Direction.REQUIRED);
            this.component.addRequiredInterface(iface);
        }
        if (!iface.containsSymbol(mc.getMethod())) {
            Method m = new Method(iface, mc.getMethod());
            iface.addMethod(m);
        }
    }
}

