/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node.visitor;

import java.util.HashSet;
import java.util.Set;
import org.ow2.dsrg.fm.tbplib.node.TBPAccept;
import org.ow2.dsrg.fm.tbplib.node.TBPAlternative;
import org.ow2.dsrg.fm.tbplib.node.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPNode;
import org.ow2.dsrg.fm.tbplib.node.TBPParallel;
import org.ow2.dsrg.fm.tbplib.node.TBPParallelOr;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNull;
import org.ow2.dsrg.fm.tbplib.node.TBPRepetition;
import org.ow2.dsrg.fm.tbplib.node.TBPSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPCheckingVisitor;
import org.ow2.dsrg.fm.tbplib.reference.MethodCall;
import org.ow2.dsrg.fm.tbplib.reference.ReferenceTransformer;

public class ProvisionResolvingVisitor<FROM, TO>
extends TBPCheckingVisitor<TBPProvisionNode<TO>, FROM> {
    private ReferenceTransformer<FROM, TO> transformer;
    private Set<TO> methods = null;

    public ProvisionResolvingVisitor(ReferenceTransformer<FROM, TO> transformer) {
        this.transformer = transformer;
    }

    @Override
    public TBPProvisionNode<TO> visitParsedAlternative(TBPAlternative<FROM> node) {
        return new TBPAlternative((TBPProvisionNode)node.getLeft().visit(this), (TBPProvisionNode)node.getRight().visit(this));
    }

    @Override
    public TBPProvisionNode<TO> visitParsedParallel(TBPParallel<FROM> node) {
        return new TBPParallel((TBPProvisionNode)node.getLeft().visit(this), (TBPProvisionNode)node.getRight().visit(this));
    }

    @Override
    public TBPProvisionNode<TO> visitParsedParallelOr(TBPParallelOr<FROM> node) {
        return new TBPParallelOr((TBPNode)node.getLeft().visit(this), (TBPNode)node.getRight().visit(this));
    }

    @Override
    public TBPProvisionNode<TO> visitParsedSequence(TBPSequence<FROM> node) {
        return new TBPSequence((TBPProvisionNode)node.getLeft().visit(this), (TBPProvisionNode)node.getRight().visit(this));
    }

    @Override
    public TBPProvisionNode<TO> visitParsedRepetition(TBPRepetition<FROM> node) {
        return new TBPRepetition((TBPProvisionNode)node.getChild().visit(this));
    }

    @Override
    public TBPProvisionNode<TO> visitLimitedReentrancy(TBPLimitedReentrancy<FROM> node) {
        return new TBPLimitedReentrancy((TBPProvisionNode)node.getChild().visit(this), node.getLimit());
    }

    @Override
    public TBPProvisionNode<TO> visitUnlimitedReentrancy(TBPUnlimitedReentrancy<FROM> node) {
        return new TBPUnlimitedReentrancy((TBPProvisionNode)node.getChild().visit(this));
    }

    @Override
    public TBPProvisionNode<TO> visitParsedProvisionContainerNode(TBPProvisionContainerNode<FROM> node) {
        this.methods = node.getFilter() == null ? new HashSet<TO>() : null;
        TBPProvisionContainerNode<TO> provision = new TBPProvisionContainerNode<TO>((TBPProvisionNode)node.getChild().visit(this), node.getName());
        if (this.methods != null) {
            provision.setFilter(this.methods);
        }
        return provision;
    }

    @Override
    public TBPProvisionNode<TO> visitParsedNull(TBPProvisionNull<FROM> node) {
        return new TBPProvisionNull();
    }

    @Override
    public TBPProvisionNode<TO> visitParsedAccept(TBPAccept<FROM> node) {
        MethodCall<TO> mc = this.transformer.resolveMethodCall(node.getMethodCall(), false);
        if (this.methods != null) {
            this.methods.add(mc.getMethod());
        }
        return new TBPAccept<Object>((MethodCall<Object>)mc, (node.getReturnValue() == null ? null : (Object)this.transformer.resolveIdentifier(node.getReturnValue())));
    }
}

