/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node.visitor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.architecture.Component;
import org.ow2.dsrg.fm.tbplib.node.TBPAccept;
import org.ow2.dsrg.fm.tbplib.node.TBPAlternative;
import org.ow2.dsrg.fm.tbplib.node.TBPAssignment;
import org.ow2.dsrg.fm.tbplib.node.TBPCondition;
import org.ow2.dsrg.fm.tbplib.node.TBPEmit;
import org.ow2.dsrg.fm.tbplib.node.TBPIf;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNode;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNull;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.node.TBPNode;
import org.ow2.dsrg.fm.tbplib.node.TBPParallel;
import org.ow2.dsrg.fm.tbplib.node.TBPParallelOr;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionBinaryNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNull;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionUnaryNode;
import org.ow2.dsrg.fm.tbplib.node.TBPRepetition;
import org.ow2.dsrg.fm.tbplib.node.TBPReturn;
import org.ow2.dsrg.fm.tbplib.node.TBPSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPSpecification;
import org.ow2.dsrg.fm.tbplib.node.TBPSwitch;
import org.ow2.dsrg.fm.tbplib.node.TBPSync;
import org.ow2.dsrg.fm.tbplib.node.TBPThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPValue;
import org.ow2.dsrg.fm.tbplib.node.TBPVariableDefinition;
import org.ow2.dsrg.fm.tbplib.node.TBPWhile;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPVisitor;
import org.ow2.dsrg.fm.tbplib.reference.Constant;
import org.ow2.dsrg.fm.tbplib.reference.EnumerationType;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;
import org.ow2.dsrg.fm.tbplib.util.CodeWriter;

public class PrintComponentVisitor<REFERENCE>
implements TBPVisitor<Object, REFERENCE> {
    private CodeWriter o;
    private Component component;
    private static final String opening = " {";
    private static final String closing = "}";

    public PrintComponentVisitor() {
        this.o = new CodeWriter(System.out, true);
    }

    public PrintComponentVisitor(CodeWriter writer) {
        this.o = writer;
    }

    private void open() {
        this.o.println(opening);
        this.o.increaseIndent();
    }

    private void close() {
        this.o.decreaseIndent();
        this.o.println();
        this.o.print(closing);
    }

    private void appendSection(String name, Collection<? extends TBPNode<REFERENCE>> container) {
        this.o.append(name);
        this.open();
        for (TBPNode<REFERENCE> node : container) {
            node.visit(this);
        }
        this.o.decreaseIndent();
        this.o.println(closing);
    }

    private void appendType(EnumerationType t) {
        this.o.append(t.getName());
        this.o.append(" = ");
        this.o.append(opening);
        Iterator<Constant> it = t.getEnums().values().iterator();
        if (it.hasNext()) {
            this.o.append(it.next().getName());
        }
        while (it.hasNext()) {
            this.o.append(", ");
            this.o.append(it.next().getName());
        }
        this.o.print(closing);
    }

    private void appendCondition(TBPCondition<REFERENCE> c) {
        this.o.append(c.toString());
    }

    public void printComponentSpecification(TBPSpecification<REFERENCE> tbp, Component component) {
        this.component = component;
        tbp.visit(this);
    }

    private void appendBinary(TBPProvisionBinaryNode<REFERENCE> node, String middle, boolean newline) {
        this.o.append('(');
        node.getLeft().visit(this);
        this.o.append(')');
        if (newline) {
            this.o.println();
            this.o.println(middle);
        } else {
            this.o.append(middle);
        }
        this.o.append('(');
        node.getRight().visit(this);
        this.o.append(')');
    }

    private void appendUnary(TBPProvisionUnaryNode<REFERENCE> node, String postfix) {
        this.o.append('(');
        node.getChild().visit(this);
        this.o.append(')').append(postfix);
    }

    private void appendBlock(TBPNode<REFERENCE> block) {
        this.open();
        block.visit(this);
        this.close();
    }

    @Override
    public Object visitParsedImperativeSequence(TBPImperativeSequence<REFERENCE> node) {
        TBPImperativeNode left = (TBPImperativeNode)node.getLeft();
        TBPImperativeNode right = (TBPImperativeNode)node.getRight();
        left.visit(this);
        this.o.println(";");
        right.visit(this);
        return null;
    }

    @Override
    public Object visitVariableDefinition(TBPVariableDefinition<REFERENCE> node) {
        if (node.isMutex()) {
            this.o.append("mutex ");
            this.o.println(node.getName());
        } else {
            this.o.append(node.getTypename().toString()).append(' ');
            this.o.append(node.getName().toString()).append(" = ");
            this.o.println(node.getInitialValue().toString());
        }
        return null;
    }

    @Override
    public Object visitParsedSwitch(TBPSwitch<REFERENCE> node) {
        List branches = node.getChildren();
        List<REFERENCE> cases = node.getCases();
        TBPImperativeNode<REFERENCE> db = node.getDefaultBranch();
        if (node.isNondeterministic()) {
            this.o.println("switch(?) {");
            for (TBPNode b : branches) {
                this.o.println("case: ");
                this.o.increaseIndent();
                b.visit(this);
                this.o.decreaseIndent();
                this.o.println();
            }
            this.o.print('}');
            return null;
        }
        this.o.append("switch(");
        node.getValue().visit(this);
        this.o.println(") {");
        for (int i = 0; i < cases.size(); ++i) {
            String c = cases.get(i).toString();
            TBPImperativeNode b = (TBPImperativeNode)branches.get(i);
            this.o.append(c);
            this.o.println(": ");
            this.o.increaseIndent();
            b.visit(this);
            this.o.decreaseIndent();
            this.o.println();
        }
        if (db != null) {
            this.o.append("default: ");
            this.o.increaseIndent();
            db.visit(this);
            this.o.decreaseIndent();
            this.o.println();
        }
        this.o.print('}');
        return null;
    }

    @Override
    public Object visitParsedIf(TBPIf<REFERENCE> node) {
        this.o.append("if(");
        this.appendCondition(node.getCondition());
        this.o.append(')');
        this.open();
        node.getChild(0).visit(this);
        this.close();
        if (node.hasElse()) {
            this.o.append(" else ");
            this.open();
            node.getChild(1).visit(this);
            this.close();
        }
        return null;
    }

    @Override
    public Object visitParsedValue(TBPValue<REFERENCE> node) {
        if (node.isMethodCall()) {
            this.o.append('!');
            this.o.append(node.getMethodCall().toString());
        } else {
            this.o.print(node.getVarname().toString());
        }
        return null;
    }

    @Override
    public Object visitParsedReturn(TBPReturn<REFERENCE> node) {
        this.o.append("return ");
        this.o.append(node.getIdf().toString());
        return null;
    }

    @Override
    public Object visitParsedWhile(TBPWhile<REFERENCE> node) {
        this.o.append("while(");
        this.appendCondition(node.getCondition());
        this.o.append(")");
        this.appendBlock(node.getChild());
        return null;
    }

    @Override
    public Object visitParsedAssignment(TBPAssignment<REFERENCE> node) {
        this.o.append(node.getIdf().toString());
        this.o.append(" <- ");
        node.getChild().visit(this);
        return null;
    }

    @Override
    public Object visitParsedMethodDeclaration(TBPMethodDeclaration<REFERENCE> node) {
        MethodSignature<REFERENCE> signature = node.getSignature();
        this.o.print(node.getFullname());
        this.o.print(signature);
        this.appendBlock(node.getChild());
        this.o.println();
        return null;
    }

    @Override
    public Object visitParsedSync(TBPSync<REFERENCE> node) {
        this.o.append("sync(").append(node.getMutex().toString()).append(')');
        this.appendBlock(node.getChild());
        return null;
    }

    @Override
    public Object visitParsedImperativeNull(TBPImperativeNull<REFERENCE> node) {
        this.o.append("NULL");
        return null;
    }

    @Override
    public Object visitParsedEmit(TBPEmit<REFERENCE> node) {
        this.o.append("!").append(node.getMethodCall().toString());
        return null;
    }

    @Override
    public Object visitParsedAlternative(TBPAlternative<REFERENCE> node) {
        this.appendBinary(node, "+", true);
        return null;
    }

    @Override
    public Object visitParsedParallel(TBPParallel<REFERENCE> node) {
        this.appendBinary(node, "|", true);
        return null;
    }

    @Override
    public Object visitParsedParallelOr(TBPParallelOr<REFERENCE> node) {
        this.appendBinary(node, "||", true);
        return null;
    }

    @Override
    public Object visitParsedSequence(TBPSequence<REFERENCE> node) {
        this.appendBinary(node, ";", false);
        return null;
    }

    @Override
    public Object visitParsedAccept(TBPAccept<REFERENCE> node) {
        this.o.append('?');
        this.o.append(node.getMethodCall().toString());
        if (node.getReturnValue() != null) {
            this.o.append(':');
            this.o.append(node.getReturnValue().toString());
        }
        return null;
    }

    @Override
    public Object visitParsedNull(TBPProvisionNull<REFERENCE> node) {
        this.o.append("NULL");
        return null;
    }

    @Override
    public Object visitLimitedReentrancy(TBPLimitedReentrancy<REFERENCE> node) {
        this.appendUnary(node, "|");
        this.o.append(Integer.toString(node.getLimit()));
        return null;
    }

    @Override
    public Object visitParsedRepetition(TBPRepetition<REFERENCE> node) {
        this.appendUnary(node, "*");
        return null;
    }

    @Override
    public Object visitUnlimitedReentrancy(TBPUnlimitedReentrancy<REFERENCE> node) {
        this.appendUnary(node, "*");
        return null;
    }

    @Override
    public Object visitParsedProvisionContainerNode(TBPProvisionContainerNode<REFERENCE> node) {
        this.o.append(node.getName());
        this.appendBlock(node.getChild());
        this.o.println();
        return null;
    }

    @Override
    public Object visitParsedThreadContainerNode(TBPThreadContainerNode<REFERENCE> node) {
        this.o.append(node.getName().toString());
        this.appendBlock(node.getChild());
        this.o.println();
        return null;
    }

    @Override
    public Object visitSpecification(TBPSpecification<REFERENCE> node) {
        this.o.print("component ");
        this.o.print(node.getComponent().toString());
        this.open();
        this.o.append("types");
        this.open();
        for (EnumerationType enumerationType : this.component.getTypes().values()) {
            this.appendType(enumerationType);
            this.o.println();
        }
        this.o.decreaseIndent();
        this.o.println(closing);
        this.o.append("vars");
        this.open();
        for (TBPVariableDefinition tBPVariableDefinition : node.getVariables()) {
            tBPVariableDefinition.visit(this);
        }
        this.o.decreaseIndent();
        this.o.println(closing);
        this.appendSection("provisions", node.getProvisions());
        this.appendSection("reactions", node.getReactions());
        this.appendSection("threads", node.getThreads());
        this.close();
        this.o.println();
        return null;
    }
}

