/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node.visitor;

import java.util.List;
import org.ow2.dsrg.fm.tbplib.node.TBPAssignment;
import org.ow2.dsrg.fm.tbplib.node.TBPCondition;
import org.ow2.dsrg.fm.tbplib.node.TBPEmit;
import org.ow2.dsrg.fm.tbplib.node.TBPIf;
import org.ow2.dsrg.fm.tbplib.node.TBPSwitch;
import org.ow2.dsrg.fm.tbplib.node.TBPSync;
import org.ow2.dsrg.fm.tbplib.node.TBPValue;
import org.ow2.dsrg.fm.tbplib.node.TBPWhile;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPDefaultVisitor;
import org.ow2.dsrg.fm.tbplib.reference.MethodCall;

public class PrefixingVisitor
extends TBPDefaultVisitor<Object, String> {
    private final String prefix;
    private final List<String> varnames;

    public PrefixingVisitor(String prefix, List<String> varnames) {
        this.prefix = prefix;
        this.varnames = varnames;
    }

    private final String prefixName(String name) {
        if (this.varnames.contains(name)) {
            return this.prefix + name;
        }
        return name;
    }

    @Override
    public Object visitParsedSwitch(TBPSwitch<String> node) {
        if (!node.isNondeterministic()) {
            node.getValue().visit(this);
        }
        return null;
    }

    @Override
    public Object visitParsedWhile(TBPWhile<String> node) {
        this.visitCondition(node.getCondition());
        return null;
    }

    @Override
    public Object visitParsedIf(TBPIf<String> node) {
        this.visitCondition(node.getCondition());
        return null;
    }

    @Override
    public Object visitParsedSync(TBPSync<String> node) {
        node.setMutex(this.prefixName(node.getMutex()));
        return null;
    }

    @Override
    public Object visitParsedAssignment(TBPAssignment<String> node) {
        node.setIdf(this.prefixName(node.getIdf()));
        return null;
    }

    @Override
    public Object visitParsedValue(TBPValue<String> node) {
        String varname = node.getVarname();
        if (varname != null) {
            node.setVarname(this.prefixName(varname));
        } else {
            this.visitMethodCall(node.getMethodCall());
        }
        return null;
    }

    @Override
    public Object visitParsedEmit(TBPEmit<String> node) {
        this.visitMethodCall(node.getMethodCall());
        return null;
    }

    private void visitMethodCall(MethodCall methodCall) {
        List paramDecl = methodCall.getParamDecl();
        int s = paramDecl.size();
        for (int i = 0; i < s; ++i) {
            paramDecl.set(i, this.prefixName((String)paramDecl.get(i)));
        }
    }

    private void visitCondition(TBPCondition<String> condition) {
        if (condition.getLeft() != null) {
            condition.setLeft(this.prefixName(condition.getLeft()));
            condition.setRight(this.prefixName(condition.getRight()));
        }
    }
}

