/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node.visitor;

import java.util.ArrayList;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.node.TBPAssignment;
import org.ow2.dsrg.fm.tbplib.node.TBPCondition;
import org.ow2.dsrg.fm.tbplib.node.TBPEmit;
import org.ow2.dsrg.fm.tbplib.node.TBPIf;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNode;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNull;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.node.TBPNode;
import org.ow2.dsrg.fm.tbplib.node.TBPReturn;
import org.ow2.dsrg.fm.tbplib.node.TBPSwitch;
import org.ow2.dsrg.fm.tbplib.node.TBPSync;
import org.ow2.dsrg.fm.tbplib.node.TBPThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPValue;
import org.ow2.dsrg.fm.tbplib.node.TBPVariableDefinition;
import org.ow2.dsrg.fm.tbplib.node.TBPWhile;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPCheckingVisitor;
import org.ow2.dsrg.fm.tbplib.reference.MethodCall;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;
import org.ow2.dsrg.fm.tbplib.reference.ReferenceTransformer;

public class ImperativeResolvingVisitor<FROM, TO>
extends TBPCheckingVisitor<TBPImperativeNode<TO>, FROM> {
    private ReferenceTransformer<FROM, TO> referenceTransformer;

    public ImperativeResolvingVisitor(ReferenceTransformer<FROM, TO> referenceTransformer) {
        this.referenceTransformer = referenceTransformer;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedSwitch(TBPSwitch<FROM> node) {
        TBPSwitch result;
        ArrayList b = new ArrayList();
        for (TBPNode ch : node.getChildren()) {
            b.add(ch.visit(this));
        }
        if (node.isNondeterministic()) {
            result = new TBPSwitch(b);
        } else {
            TBPValue rval = (TBPValue)node.getValue().visit(this);
            List<TO> cases = this.resolveList(node.getCases());
            result = new TBPSwitch(rval, b, cases);
        }
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedIf(TBPIf<FROM> node) {
        TBPIf<TO> result;
        TBPCondition<TO> rcond = this.resolveCondition(node.getCondition());
        TBPImperativeNode rifb = (TBPImperativeNode)node.getChild(0).visit(this);
        if (node.hasElse()) {
            TBPImperativeNode relseb = (TBPImperativeNode)node.getChild(1).visit(this);
            result = new TBPIf<TO>(rcond, rifb, relseb);
        } else {
            result = new TBPIf<TO>(rcond, rifb, null);
        }
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedWhile(TBPWhile<FROM> node) {
        TBPWhile<TO> result = new TBPWhile<TO>(this.resolveCondition(node.getCondition()), (TBPImperativeNode)node.getChild().visit(this));
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedImperativeSequence(TBPImperativeSequence<FROM> node) {
        TBPImperativeSequence result = new TBPImperativeSequence((TBPImperativeNode)node.getLeft().visit(this), (TBPImperativeNode)node.getRight().visit(this));
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedAssignment(TBPAssignment<FROM> node) {
        TBPValue rval = (TBPValue)node.getChild().visit(this);
        TO ref = this.referenceTransformer.resolveIdentifier(node.getIdf());
        TBPAssignment<TO> result = new TBPAssignment<TO>(ref, rval);
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedEmit(TBPEmit<FROM> node) {
        TBPEmit<TO> result = new TBPEmit<TO>(this.referenceTransformer.resolveMethodCall(node.getMethodCall(), true));
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedImperativeNull(TBPImperativeNull<FROM> node) {
        TBPImperativeNull result = new TBPImperativeNull();
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedMethodDeclaration(TBPMethodDeclaration<FROM> node) {
        TO iface = this.referenceTransformer.resolveInterface(node.getInterface());
        TO method = this.referenceTransformer.resolveMethod(node.getMethod(), iface);
        MethodSignature<TO> ms = this.referenceTransformer.resolveMethodSignature(node.getSignature(), method);
        this.referenceTransformer.enterMethod(method);
        List resolved_variables = this.getResolvedVariables(node.getLocalVariables());
        TBPMethodDeclaration<TO> result = new TBPMethodDeclaration<TO>(iface, method, ms, (TBPImperativeNode)node.getChild().visit(this), resolved_variables);
        this.referenceTransformer.leaveMethod();
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    private List<TBPVariableDefinition<TO>> getResolvedVariables(List<TBPVariableDefinition<FROM>> variables) {
        ArrayList<TBPVariableDefinition<TO>> resolved_variables = new ArrayList<TBPVariableDefinition<TO>>(variables.size());
        for (TBPVariableDefinition<FROM> variable : variables) {
            resolved_variables.add((TBPVariableDefinition)variable.visit(this));
        }
        return resolved_variables;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedReturn(TBPReturn<FROM> node) {
        TO ridf = this.referenceTransformer.resolveIdentifier(node.getIdf());
        TBPReturn<TO> result = new TBPReturn<TO>(ridf);
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedSync(TBPSync<FROM> node) {
        TO ref = this.referenceTransformer.resolveIdentifier(node.getMutex());
        TBPSync<TO> result = new TBPSync<TO>(ref, (TBPImperativeNode)node.getChild().visit(this));
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedValue(TBPValue<FROM> node) {
        TBPValue<TO> result;
        MethodCall<FROM> mc = node.getMethodCall();
        FROM varname = node.getVarname();
        assert (mc != null || varname != null);
        if (mc == null) {
            TO ref = this.referenceTransformer.resolveIdentifier(varname);
            result = new TBPValue<TO>(ref);
        } else {
            MethodCall<TO> rmc = this.referenceTransformer.resolveMethodCall(mc, true);
            result = new TBPValue<TO>(rmc);
        }
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitParsedThreadContainerNode(TBPThreadContainerNode<FROM> node) {
        TO thread = this.referenceTransformer.resolveThread(node.getName());
        this.referenceTransformer.enterThread(thread);
        List resolved_variables = this.getResolvedVariables(node.getLocalVariables());
        TBPThreadContainerNode<TO> result = new TBPThreadContainerNode<TO>(thread, (TBPImperativeNode)node.getChild().visit(this), resolved_variables);
        this.referenceTransformer.leaveThread();
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    @Override
    public TBPImperativeNode<TO> visitVariableDefinition(TBPVariableDefinition<FROM> node) {
        TBPVariableDefinition<TO> result;
        if (node.isMutex()) {
            result = new TBPVariableDefinition<TO>(this.referenceTransformer.resolveIdentifier(node.getName()));
        } else {
            TO type = this.referenceTransformer.resolveType(node.getTypename());
            result = new TBPVariableDefinition<TO>(type, this.referenceTransformer.resolveVariable(node.getName()), this.referenceTransformer.resolveConstant(node.getInitialValue(), type));
        }
        result.setAnnotation(node.getAnnotation());
        return result;
    }

    private List<TO> resolveList(List<FROM> source) {
        ArrayList<TO> dest = new ArrayList<TO>(source.size());
        for (FROM element : source) {
            dest.add(this.referenceTransformer.resolveIdentifier(element));
        }
        return dest;
    }

    private TBPCondition<TO> resolveCondition(TBPCondition<FROM> source) {
        if (source.isDeterministic()) {
            TO lref = this.referenceTransformer.resolveIdentifier(source.getLeft());
            TO rref = this.referenceTransformer.resolveIdentifier(source.getRight());
            return new TBPCondition<TO>(lref, rref);
        }
        return new TBPCondition();
    }
}

