/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node.visitor;

import org.ow2.dsrg.fm.tbplib.node.TBPAssignment;
import org.ow2.dsrg.fm.tbplib.node.TBPEmit;
import org.ow2.dsrg.fm.tbplib.node.TBPIf;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNull;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeSequence;
import org.ow2.dsrg.fm.tbplib.node.TBPMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.node.TBPNode;
import org.ow2.dsrg.fm.tbplib.node.TBPReturn;
import org.ow2.dsrg.fm.tbplib.node.TBPSpecification;
import org.ow2.dsrg.fm.tbplib.node.TBPSwitch;
import org.ow2.dsrg.fm.tbplib.node.TBPSync;
import org.ow2.dsrg.fm.tbplib.node.TBPThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPValue;
import org.ow2.dsrg.fm.tbplib.node.TBPVariableDefinition;
import org.ow2.dsrg.fm.tbplib.node.TBPWhile;
import org.ow2.dsrg.fm.tbplib.node.visitor.ImperativeVisitor;

public class CheckReturnsVisitor<REFERENCE>
extends ImperativeVisitor<Boolean, REFERENCE> {
    @Override
    public Boolean visitParsedImperativeSequence(TBPImperativeSequence<REFERENCE> node) {
        return (Boolean)node.getLeft().visit(this) != false || (Boolean)node.getRight().visit(this) != false;
    }

    @Override
    public Boolean visitVariableDefinition(TBPVariableDefinition<REFERENCE> node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitParsedSwitch(TBPSwitch<REFERENCE> node) {
        for (TBPNode child : node.getChildren()) {
            if (!((Boolean)child.visit(this)).equals(Boolean.FALSE)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitParsedIf(TBPIf<REFERENCE> node) {
        if (!node.hasElse()) {
            return Boolean.FALSE;
        }
        return (Boolean)node.getChild(0).visit(this) != false && (Boolean)node.getChild(1).visit(this) != false;
    }

    @Override
    public Boolean visitParsedValue(TBPValue<REFERENCE> node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitParsedReturn(TBPReturn<REFERENCE> node) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitParsedWhile(TBPWhile<REFERENCE> node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitParsedAssignment(TBPAssignment<REFERENCE> node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitParsedMethodDeclaration(TBPMethodDeclaration<REFERENCE> node) {
        throw new RuntimeException("Unexpected type of node: " + node.getClass());
    }

    @Override
    public Boolean visitParsedSync(TBPSync<REFERENCE> node) {
        return (Boolean)node.getChild().visit(this);
    }

    @Override
    public Boolean visitParsedImperativeNull(TBPImperativeNull<REFERENCE> node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitParsedThreadContainerNode(TBPThreadContainerNode<REFERENCE> node) {
        return (Boolean)node.getChild().visit(this);
    }

    @Override
    public Boolean visitParsedEmit(TBPEmit<REFERENCE> node) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visitSpecification(TBPSpecification<REFERENCE> node) {
        for (TBPMethodDeclaration<REFERENCE> reaction : node.getReactions()) {
            if (((Boolean)reaction.visit(this)).booleanValue()) continue;
            throw new RuntimeException("Not all code paths return value in reaction: " + reaction.getMethod().toString());
        }
        return Boolean.TRUE;
    }
}

