/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node;

import java.util.List;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNaryNode;
import org.ow2.dsrg.fm.tbplib.node.TBPImperativeNode;
import org.ow2.dsrg.fm.tbplib.node.TBPValue;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPVisitor;

public class TBPSwitch<REFERENCE>
extends TBPImperativeNaryNode<REFERENCE> {
    private final List<REFERENCE> cases;
    private final TBPImperativeNode<REFERENCE> defaultBranch;
    private final TBPValue<REFERENCE> value;

    public TBPSwitch(List<TBPImperativeNode<REFERENCE>> branches) {
        this.cases = null;
        this.defaultBranch = null;
        this.value = null;
        for (TBPImperativeNode<REFERENCE> branch : branches) {
            this.addChild(branch);
        }
    }

    public TBPSwitch(TBPValue<REFERENCE> value, List<TBPImperativeNode<REFERENCE>> branches, List<REFERENCE> cases) {
        this.value = value;
        int csize = cases.size();
        int bsize = branches.size();
        assert (csize == bsize || bsize == csize + 1);
        this.cases = cases;
        this.defaultBranch = bsize - 1 == csize ? branches.get(csize) : null;
        for (TBPImperativeNode<REFERENCE> branch : branches) {
            assert (branch != null);
            this.addChild(branch);
        }
    }

    public boolean isNondeterministic() {
        return this.cases == null;
    }

    public boolean isDeterministic() {
        return this.cases != null;
    }

    public List<REFERENCE> getCases() {
        return this.cases;
    }

    public TBPValue<REFERENCE> getValue() {
        return this.value;
    }

    public TBPImperativeNode<REFERENCE> getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    public <RESULT> RESULT visit(TBPVisitor<RESULT, REFERENCE> visitor) {
        return visitor.visitParsedSwitch(this);
    }
}

