/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node;

import java.util.ArrayList;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.node.TBPLimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPMethodDeclaration;
import org.ow2.dsrg.fm.tbplib.node.TBPNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNode;
import org.ow2.dsrg.fm.tbplib.node.TBPProvisionNull;
import org.ow2.dsrg.fm.tbplib.node.TBPThreadContainerNode;
import org.ow2.dsrg.fm.tbplib.node.TBPUnlimitedReentrancy;
import org.ow2.dsrg.fm.tbplib.node.TBPVariableDefinition;
import org.ow2.dsrg.fm.tbplib.node.visitor.ImperativeResolvingVisitor;
import org.ow2.dsrg.fm.tbplib.node.visitor.ProvisionResolvingVisitor;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPDefaultVisitor;
import org.ow2.dsrg.fm.tbplib.node.visitor.TBPVisitor;
import org.ow2.dsrg.fm.tbplib.reference.ReferenceTransformer;

public class TBPSpecification<REFERENCE> {
    protected REFERENCE component;
    protected List<TBPVariableDefinition<REFERENCE>> variables;
    protected List<TBPProvisionContainerNode<REFERENCE>> provisions;
    protected List<TBPMethodDeclaration<REFERENCE>> reactions;
    protected List<TBPThreadContainerNode<REFERENCE>> threads;

    public TBPSpecification(REFERENCE component, List<TBPVariableDefinition<REFERENCE>> variables, List<TBPProvisionContainerNode<REFERENCE>> provisions, List<TBPMethodDeclaration<REFERENCE>> reactions, List<TBPThreadContainerNode<REFERENCE>> threads) {
        this.component = component;
        this.variables = variables;
        this.provisions = provisions;
        this.reactions = reactions;
        this.threads = threads;
    }

    public List<TBPVariableDefinition<REFERENCE>> getVariables() {
        return this.variables;
    }

    public List<TBPProvisionContainerNode<REFERENCE>> getProvisions() {
        return this.provisions;
    }

    public List<TBPMethodDeclaration<REFERENCE>> getReactions() {
        return this.reactions;
    }

    public List<TBPThreadContainerNode<REFERENCE>> getThreads() {
        return this.threads;
    }

    public REFERENCE getComponent() {
        return this.component;
    }

    public void limitReentrancy(final int limit) {
        TBPDefaultVisitor replaceReentrancy = new TBPDefaultVisitor<Object, REFERENCE>(){

            @Override
            public Object visitUnlimitedReentrancy(TBPUnlimitedReentrancy<REFERENCE> node) {
                TBPProvisionNode child = (TBPProvisionNode)node.getChild();
                TBPNode parent = node.getParent();
                int idx = parent.getChildren().indexOf(node);
                node.setChild(new TBPProvisionNull());
                TBPLimitedReentrancy replacement = new TBPLimitedReentrancy(child, limit);
                parent.setChild(idx, replacement);
                return null;
            }
        };
        for (TBPProvisionContainerNode<REFERENCE> provision : this.provisions) {
            for (TBPNode tBPNode : provision) {
                ((TBPProvisionNode)tBPNode).visit(replaceReentrancy);
            }
        }
    }

    public <TO> TBPSpecification<TO> resolve(ReferenceTransformer<REFERENCE, TO> transformer) {
        ArrayList<TBPProvisionContainerNode<REFERENCE>> resolved_provisions = new ArrayList<TBPProvisionContainerNode<REFERENCE>>(this.provisions.size());
        ProvisionResolvingVisitor<REFERENCE, TO> pvisitor = new ProvisionResolvingVisitor<REFERENCE, TO>(transformer);
        for (TBPProvisionContainerNode<TO> tBPProvisionContainerNode : this.provisions) {
            resolved_provisions.add((TBPProvisionContainerNode)tBPProvisionContainerNode.visit(pvisitor));
        }
        ArrayList<TBPThreadContainerNode<REFERENCE>> resolved_threads = new ArrayList<TBPThreadContainerNode<REFERENCE>>(this.threads.size());
        ImperativeResolvingVisitor<REFERENCE, TO> imperativeResolvingVisitor = new ImperativeResolvingVisitor<REFERENCE, TO>(transformer);
        for (TBPThreadContainerNode<TO> tBPThreadContainerNode : this.threads) {
            resolved_threads.add((TBPThreadContainerNode)tBPThreadContainerNode.visit(imperativeResolvingVisitor));
        }
        ArrayList<TBPMethodDeclaration<REFERENCE>> resolved_reactions = new ArrayList<TBPMethodDeclaration<REFERENCE>>(this.reactions.size());
        for (TBPMethodDeclaration<TO> tBPMethodDeclaration : this.reactions) {
            resolved_reactions.add((TBPMethodDeclaration)tBPMethodDeclaration.visit(imperativeResolvingVisitor));
        }
        ArrayList<TBPVariableDefinition<REFERENCE>> arrayList = new ArrayList<TBPVariableDefinition<REFERENCE>>(this.variables.size());
        for (TBPVariableDefinition<TO> tBPVariableDefinition : this.variables) {
            arrayList.add((TBPVariableDefinition)tBPVariableDefinition.visit(imperativeResolvingVisitor));
        }
        return new TBPSpecification<TO>(transformer.resolveComponent(this.component), arrayList, resolved_provisions, resolved_reactions, resolved_threads);
    }

    public <RESULT> RESULT visit(TBPVisitor<RESULT, REFERENCE> visitor) {
        return visitor.visitSpecification(this);
    }
}

