/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.node;

import java.util.Iterator;
import java.util.Set;

public class TBPCondition<REFERENCE>
implements Cloneable {
    private REFERENCE right;
    private REFERENCE left;
    private boolean negate = false;
    private Set<REFERENCE> inSet;
    private int precomputedHashCode;

    public TBPCondition(REFERENCE left, REFERENCE right) {
        this(left, right, false);
    }

    public TBPCondition(REFERENCE left, REFERENCE right, boolean negate) {
        this.left = left;
        this.right = right;
        this.negate = negate;
        this.recomputeHashCode();
    }

    public TBPCondition(REFERENCE left, Set<REFERENCE> inSet) {
        this(left, inSet, false);
    }

    public TBPCondition(REFERENCE left, Set<REFERENCE> inSet, boolean negate) {
        this.left = left;
        this.inSet = inSet;
        this.negate = negate;
        this.recomputeHashCode();
    }

    public TBPCondition() {
        this.right = null;
        this.left = null;
        this.recomputeHashCode();
    }

    public REFERENCE getLeft() {
        return this.left;
    }

    public REFERENCE getRight() {
        return this.right;
    }

    public Set<REFERENCE> getInSet() {
        return this.inSet;
    }

    public void setRight(REFERENCE right) {
        assert (this.inSet == null);
        this.right = right;
        this.recomputeHashCode();
    }

    public void setLeft(REFERENCE left) {
        assert (this.inSet == null);
        this.left = left;
        this.recomputeHashCode();
    }

    public boolean isNondeterministic() {
        return this.left == null && this.right == null;
    }

    public boolean isDeterministic() {
        return !this.isNondeterministic();
    }

    public boolean isSetCondition() {
        return this.inSet != null;
    }

    public TBPCondition<REFERENCE> createNegation() {
        Object result = this.clone();
        ((TBPCondition)result).negate = !this.negate;
        return result;
    }

    public boolean isNegated() {
        return this.negate;
    }

    public TBPCondition<REFERENCE> clone() {
        if (this.inSet != null) {
            return new TBPCondition<REFERENCE>(this.left, this.inSet, this.negate);
        }
        if (this.isNondeterministic()) {
            return new TBPCondition<REFERENCE>();
        }
        return new TBPCondition<REFERENCE>(this.left, this.right, this.negate);
    }

    public String toString() {
        if (this.isNondeterministic()) {
            return "?";
        }
        if (this.inSet == null) {
            if (this.negate) {
                return this.left.toString() + " != " + this.right.toString();
            }
            return this.left.toString() + " == " + this.right.toString();
        }
        if (this.negate) {
            return this.left.toString() + " notin " + this.inSetToString();
        }
        return this.left.toString() + " in " + this.inSetToString();
    }

    private String inSetToString() {
        REFERENCE ref;
        StringBuilder bfr = new StringBuilder();
        bfr.append('[');
        Iterator<REFERENCE> it = this.inSet.iterator();
        if (it.hasNext()) {
            ref = it.next();
            bfr.append(ref.toString());
        }
        while (it.hasNext()) {
            ref = it.next();
            bfr.append(", ");
            bfr.append(ref.toString());
        }
        bfr.append(']');
        return bfr.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TBPCondition) {
            TBPCondition cond = (TBPCondition)obj;
            return this.negate == cond.negate && (this.left == null && cond.left == null || this.left.equals(cond.left)) && (this.right == null && cond.right == null || this.right.equals(cond.right)) && (this.inSet == null && cond.inSet == null || ((Object)this.inSet).equals(cond.inSet));
        }
        return false;
    }

    public int hashCode() {
        return this.precomputedHashCode;
    }

    private void recomputeHashCode() {
        int prime = 7823;
        int result = this.inSet == null ? 0 : ((Object)this.inSet).hashCode();
        result *= prime;
        result += this.left == null ? 0 : this.left.hashCode();
        result *= prime;
        result += this.right == null ? 0 : this.right.hashCode();
        result *= prime;
        this.precomputedHashCode = result += this.negate ? 0 : 1;
    }
}

