/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.ltsa;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.dsrg.fm.tbplib.ltsa.DynamicDFA;
import org.ow2.dsrg.fm.tbplib.ltsa.FAState;
import org.ow2.dsrg.fm.tbplib.ltsa.NFA;

public class DynamicNFA
implements NFA {
    private List<NFAState> states;
    private NFAState initialState;
    private Set<NFAState> finalStates;

    public DynamicNFA() {
        this.states = new ArrayList<NFAState>();
        this.initialState = null;
        this.finalStates = new HashSet<NFAState>();
    }

    private DynamicNFA(int states, int finalStates) {
        this.states = new ArrayList<NFAState>(states);
        this.initialState = null;
        this.finalStates = new HashSet<NFAState>(finalStates);
    }

    @Override
    public List<Integer> nextStates(int stateId, long event) {
        return this.states.get(stateId).getEdges().get(event);
    }

    @Override
    public int initialState() {
        return this.initialState.getId();
    }

    @Override
    public boolean isFinal(int stateId) {
        return this.finalStates.contains(this.states.get(stateId));
    }

    @Override
    public int getNumberOfState() {
        return this.states.size();
    }

    @Override
    public Map<Long, List<Integer>> getEdges(int state) {
        return this.states.get((int)state).edges;
    }

    public void clear() {
        this.initialState = null;
        this.states.clear();
        this.finalStates.clear();
    }

    private void importStates(List<NFAState> newStates) {
        int offset = this.states.size();
        for (NFAState state : newStates) {
            state.offsetState(offset);
            this.states.add(state);
        }
    }

    private NFAState createState() {
        NFAState state = new NFAState(this.states.size());
        this.states.add(state);
        return state;
    }

    private void set(DynamicNFA a) {
        this.initialState = a.initialState;
        this.finalStates = a.finalStates;
        this.states = a.states;
    }

    public DynamicNFA addAlternative(DynamicNFA aut) {
        assert (Collections.disjoint(this.states, aut.states));
        this.importStates(aut.states);
        this.initialState.addAllEdges(aut.initialState.getEdges());
        this.finalStates.addAll(aut.finalStates);
        if (aut.finalStates.contains(aut.initialState)) {
            this.finalStates.add(this.initialState);
        }
        aut.clear();
        return this;
    }

    private static DynamicNFA createParallel(DynamicNFA a, DynamicNFA b) {
        int j;
        int i;
        int sz1 = a.states.size();
        int sz2 = b.states.size();
        DynamicNFA result = new DynamicNFA();
        NFAState[][] temp = new NFAState[sz1][sz2];
        for (i = 0; i < sz1; ++i) {
            for (j = 0; j < sz2; ++j) {
                temp[i][j] = result.createState();
            }
        }
        for (i = 0; i < sz1; ++i) {
            for (j = 0; j < sz2; ++j) {
                NFAState s = temp[i][j];
                NFAState c1 = a.states.get(i);
                for (Map.Entry<Long, List<Integer>> entry : c1.getEdges().entrySet()) {
                    for (int idx : entry.getValue()) {
                        s.addEdge(entry.getKey(), temp[idx][j].getId());
                    }
                }
                NFAState c2 = b.states.get(j);
                for (Map.Entry<Long, List<Integer>> entry : c2.getEdges().entrySet()) {
                    for (int idx : entry.getValue()) {
                        s.addEdge(entry.getKey(), temp[i][idx].getId());
                    }
                }
            }
        }
        result.initialState = temp[a.initialState.getId()][b.initialState.getId()];
        for (NFAState s1 : a.finalStates) {
            for (NFAState s2 : b.finalStates) {
                result.finalStates.add(temp[s1.getId()][s2.getId()]);
            }
        }
        return result;
    }

    public DynamicNFA addParallel(DynamicNFA aut) {
        this.set(DynamicNFA.createParallel(this, aut));
        return this;
    }

    public DynamicNFA addParallelOr(DynamicNFA aut) {
        DynamicNFA par = DynamicNFA.createParallel(this, aut);
        return this.addAlternative(aut).addAlternative(par);
    }

    public DynamicNFA addLimitedReentrancy(int k) {
        assert (k >= 1);
        if (k == 1) {
            return this;
        }
        this.addRepetition();
        for (int i = 0; i < k - 1; ++i) {
            this.addParallel(this);
        }
        return this;
    }

    public DynamicNFA addRepetition() {
        NFAState newStart = this.createState();
        this.finalStates.add(newStart);
        for (NFAState s : this.finalStates) {
            s.addAllEdges(this.initialState.getEdges());
        }
        this.initialState = newStart;
        return this;
    }

    public int allocateState() {
        return this.createState().getId();
    }

    public void addEdge(int src, long event, int dst) {
        NFAState state = this.states.get(src);
        state.addEdge(event, dst);
    }

    public boolean hasInitial() {
        return this.initialState != null;
    }

    public void markFinal(int state) {
        this.finalStates.add(this.states.get(state));
    }

    public void unmarkFinal(int state) {
        this.finalStates.remove(this.states.get(state));
    }

    public void setInitial(int state) {
        this.initialState = this.states.get(state);
    }

    public DynamicNFA addSequence(DynamicNFA aut) {
        assert (Collections.disjoint(this.states, aut.states));
        this.importStates(aut.states);
        for (NFAState s : this.finalStates) {
            s.addAllEdges(aut.initialState.getEdges());
        }
        if (aut.finalStates.contains(aut.initialState)) {
            this.finalStates.addAll(aut.finalStates);
        } else {
            this.finalStates = aut.finalStates;
        }
        return this;
    }

    public static DynamicNFA createNull() {
        DynamicNFA result = new DynamicNFA(1, 1);
        result.initialState = result.createState();
        result.finalStates.add(result.initialState);
        return result;
    }

    public static DynamicNFA createSimple(long symbol) {
        DynamicNFA result = new DynamicNFA(2, 1);
        result.initialState = result.createState();
        NFAState fin = result.createState();
        result.initialState.addEdge(symbol, fin.getId());
        result.finalStates.add(fin);
        return result;
    }

    public DynamicDFA determinize() {
        Integer state;
        DynamicDFA dfa = new DynamicDFA();
        ArrayList<Integer> detStates = new ArrayList<Integer>();
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        HashMap<Set, Integer> setToState = new HashMap<Set, Integer>();
        HashMap<Integer, Set> stateToSet = new HashMap<Integer, Set>();
        int detStart = dfa.allocateState();
        dfa.setInitial(detStart);
        if (this.finalStates.contains(this.initialState)) {
            dfa.markFinal(detStart);
        }
        Set<NFAState> startSet = Collections.singleton(this.initialState);
        queue.add(detStart);
        stateToSet.put(detStart, startSet);
        setToState.put(startSet, detStart);
        while ((state = (Integer)queue.poll()) != null) {
            detStates.add(state);
            Collection actSet = (Collection)stateToSet.get(state);
            EdgeMultiMap m = new EdgeMultiMap();
            for (NFAState nFAState : actSet) {
                for (Map.Entry<Long, List<Integer>> entry : nFAState.getEdges().entrySet()) {
                    for (int dst : entry.getValue()) {
                        m.put(entry.getKey(), this.states.get(dst));
                    }
                }
            }
            for (Map.Entry entry : m.entrySet()) {
                long symbol = (Long)entry.getKey();
                Set setTarget = (Set)entry.getValue();
                Integer target = (Integer)setToState.get(setTarget);
                if (target == null) {
                    target = dfa.allocateState();
                    if (!Collections.disjoint(setTarget, this.finalStates)) {
                        dfa.markFinal(target);
                    }
                    queue.add(target);
                    setToState.put(setTarget, target);
                    stateToSet.put(target, setTarget);
                }
                dfa.addEdge(state, symbol, target);
            }
        }
        return dfa;
    }

    private static class EdgeMultiMap
    extends HashMap<Long, Set<NFAState>> {
        private EdgeMultiMap() {
        }

        @Override
        public void put(Long key, NFAState value) {
            if (this.containsKey(key)) {
                ((Set)this.get(key)).add(value);
            } else {
                HashSet<NFAState> newBucket = new HashSet<NFAState>();
                newBucket.add(value);
                this.put(key, newBucket);
            }
        }
    }

    protected static class NFAState
    extends FAState<List<Integer>> {
        public NFAState(int id) {
            super(id);
        }

        private List<Integer> assureNeighbourList(long event) {
            ArrayList l = (ArrayList)this.edges.get(event);
            if (l == null) {
                l = new ArrayList();
                this.edges.put(event, l);
            }
            return l;
        }

        public void addEdge(long event, int state) {
            this.assureNeighbourList(event).add(state);
        }

        public void addEdges(long event, List<Integer> states) {
            List<Integer> l = this.assureNeighbourList(event);
            l.addAll(states);
        }

        public void addAllEdges(Map<Long, List<Integer>> newEdges) {
            for (Map.Entry<Long, List<Integer>> entry : newEdges.entrySet()) {
                this.addEdges(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Map<Long, List<Integer>> getEdges() {
            return this.edges;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder("E(");
            boolean first = true;
            for (Map.Entry entry : this.edges.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    bld.append(',');
                }
                boolean f = true;
                bld.append(entry.getKey());
                bld.append("->{");
                Iterator i$ = ((List)entry.getValue()).iterator();
                while (i$.hasNext()) {
                    int state = (Integer)i$.next();
                    if (f) {
                        f = false;
                    } else {
                        bld.append(',');
                    }
                    bld.append(state);
                }
                bld.append('}');
            }
            bld.append(')');
            return bld.toString();
        }

        private void offsetState(int offset) {
            this.offsetId(offset);
            for (List l : this.edges.values()) {
                for (int i = 0; i < l.size(); ++i) {
                    l.set(i, (Integer)l.get(i) + offset);
                }
            }
        }
    }
}

