/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.ltsa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.ow2.dsrg.fm.tbplib.ltsa.DFA;
import org.ow2.dsrg.fm.tbplib.ltsa.FAState;

public class DynamicDFA
implements DFA {
    private List<DFAState> states;
    private DFAState initialState;
    private Set<DFAState> finalStates;

    public DynamicDFA() {
        this.states = new ArrayList<DFAState>();
        this.initialState = null;
        this.finalStates = new HashSet<DFAState>();
    }

    private DynamicDFA(int states, int finalStates) {
        this.states = new ArrayList<DFAState>(states);
        this.initialState = null;
        this.finalStates = new HashSet<DFAState>(finalStates);
    }

    @Override
    public int nextState(int stateId, long event) {
        Integer target = (Integer)this.states.get((int)stateId).edges.get(event);
        if (target == null) {
            return -1;
        }
        return target;
    }

    @Override
    public int initialState() {
        return this.initialState.getId();
    }

    @Override
    public boolean isFinal(int stateId) {
        return this.finalStates.contains(this.states.get(stateId));
    }

    @Override
    public int getNumberOfState() {
        return this.states.size();
    }

    @Override
    public Map<Long, Integer> getEdges(int state) {
        return this.states.get((int)state).edges;
    }

    public void clear() {
        this.initialState = null;
        this.states.clear();
        this.finalStates.clear();
    }

    public int allocateState() {
        DFAState state = new DFAState(this.states.size());
        this.states.add(state);
        return state.getId();
    }

    public void addEdge(int src, long event, int dst) {
        DFAState state = this.states.get(src);
        state.addEdge(event, dst);
    }

    public boolean hasInitial() {
        return this.initialState != null;
    }

    public void markFinal(int state) {
        this.finalStates.add(this.states.get(state));
    }

    public void unmarkFinal(int state) {
        this.finalStates.remove(this.states.get(state));
    }

    public void setInitial(int state) {
        this.initialState = this.states.get(state);
    }

    public DynamicDFA makeMinimal() {
        DynamicDFA dfa = new DynamicDFA();
        HashMap<DFAState, Integer> stateToClass = new HashMap<DFAState, Integer>();
        HashMap<Integer, Set<DFAState>> classToState = new HashMap<Integer, Set<DFAState>>();
        DynamicDFA.createPartitions(this.states, this.finalStates, classToState, stateToClass);
        Set classes = classToState.keySet();
        HashMap<Integer, Integer> classesToRepresentants = new HashMap<Integer, Integer>();
        for (Integer i : classes) {
            classesToRepresentants.put(i, dfa.allocateState());
        }
        Iterator i$ = classes.iterator();
        while (i$.hasNext()) {
            int c = (Integer)i$.next();
            int newSource = (Integer)classesToRepresentants.get(c);
            DFAState oldSource = (DFAState)((Set)classToState.get(c)).iterator().next();
            for (Map.Entry<Long, Integer> entry : oldSource.getEdges().entrySet()) {
                int classTarget = (Integer)stateToClass.get(this.states.get(entry.getValue()));
                Integer newTarget = (Integer)classesToRepresentants.get(classTarget);
                if (newTarget == null) continue;
                dfa.addEdge(newSource, entry.getKey(), newTarget);
            }
        }
        int classInit = (Integer)stateToClass.get(this.initialState);
        int newInit = (Integer)classesToRepresentants.get(classInit);
        dfa.setInitial(newInit);
        for (DFAState f : this.finalStates) {
            Integer classFinal = (Integer)stateToClass.get(f);
            Integer newFinal = (Integer)classesToRepresentants.get(classFinal);
            dfa.markFinal(newFinal);
        }
        return dfa;
    }

    private static Map<DFAState, Map<Long, Integer>> getStatesNeigborhood(List<DFAState> states, Map<DFAState, Integer> stateToClass, DFAState deadEndState) {
        HashMap<DFAState, Map<Long, Integer>> env = new HashMap<DFAState, Map<Long, Integer>>();
        int deadEndClass = stateToClass.get(deadEndState);
        for (DFAState s : states) {
            HashMap<Long, Integer> myEnv = new HashMap<Long, Integer>();
            for (Map.Entry<Long, Integer> entry : s.getEdges().entrySet()) {
                Integer targetClass = stateToClass.get(states.get(entry.getValue()));
                if (targetClass == deadEndClass) continue;
                myEnv.put(entry.getKey(), targetClass);
            }
            env.put(s, myEnv);
        }
        return env;
    }

    private static void createPartitions(List<DFAState> allStates, Collection<DFAState> finalStates, Map<Integer, Set<DFAState>> classToState, Map<DFAState, Integer> stateToClass) {
        classToState.clear();
        stateToClass.clear();
        LinkedList<Integer> classes = new LinkedList<Integer>();
        DFAState deadEndState = new DFAState(-1);
        allStates.add(deadEndState);
        for (DFAState s : allStates) {
            stateToClass.put(s, 0);
        }
        for (DFAState s : finalStates) {
            stateToClass.put(s, 1);
        }
        classToState.put(0, new HashSet());
        classToState.put(1, new HashSet());
        for (DFAState s : allStates) {
            classToState.get(stateToClass.get(s)).add(s);
        }
        classes.add(0);
        classes.add(1);
        int lastClass = 2;
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            Map<DFAState, Map<Long, Integer>> env = DynamicDFA.getStatesNeigborhood(allStates, stateToClass, deadEndState);
            ListIterator<Integer> it = classes.listIterator();
            while (it.hasNext()) {
                int c = (Integer)it.next();
                Set<DFAState> classStates = classToState.get(c);
                HashSet<Map<Long, Integer>> transitionPattern = new HashSet<Map<Long, Integer>>();
                for (DFAState s : classStates) {
                    transitionPattern.add(env.get(s));
                }
                int numSubClasses = transitionPattern.size();
                if (numSubClasses == 1) continue;
                it.remove();
                classToState.remove(c);
                for (int i = 0; i < numSubClasses; ++i) {
                    int newClass = lastClass + i;
                    it.add(newClass);
                    classToState.put(newClass, new HashSet());
                }
                ArrayList transList = new ArrayList(transitionPattern);
                for (DFAState s : classStates) {
                    int clsIdx = transList.indexOf(env.get(s));
                    assert (clsIdx != -1);
                    int newClass = lastClass + clsIdx;
                    stateToClass.put(s, newClass);
                    classToState.get(newClass).add(s);
                }
                lastClass += numSubClasses;
                hasChanged = true;
            }
        }
        allStates.remove(allStates.size() - 1);
        classToState.remove(stateToClass.get(deadEndState));
    }

    protected static class DFAState
    extends FAState<Integer> {
        public DFAState(int id) {
            super(id);
        }

        public void addEdge(long event, int state) {
            assert (!this.edges.containsKey(event));
            this.edges.put(event, state);
        }

        public void addAllEdges(Map<Long, Integer> newEdges) {
            for (Map.Entry<Long, Integer> entry : newEdges.entrySet()) {
                this.addEdge(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Map<Long, Integer> getEdges() {
            return this.edges;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder("E(");
            boolean first = true;
            for (Map.Entry entry : this.edges.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    bld.append(',');
                }
                bld.append(entry.getKey());
                bld.append("-> ");
                bld.append(entry.getValue());
            }
            bld.append(')');
            return bld.toString();
        }

        private void offsetState(int offset) {
            this.offsetId(offset);
            for (Map.Entry entry : this.edges.entrySet()) {
                entry.setValue((Integer)entry.getValue() + offset);
            }
        }
    }
}

