/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.ltsa;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ow2.dsrg.fm.tbplib.event.EventCode;
import org.ow2.dsrg.fm.tbplib.event.EventTable;
import org.ow2.dsrg.fm.tbplib.ltsa.DFA;
import org.ow2.dsrg.fm.tbplib.ltsa.Observer;

public class CompactDFA
implements Observer {
    private boolean[] methodFilter;
    private boolean[] finalStates;
    private int initialState;
    private int[] methodOffsets;
    private int[] methodReturnEventsOffset;
    private int[] methodCallEvents;
    private int[] methodReturnEvents;
    private int[][][] transitionTable;

    private CompactDFA() {
    }

    @Override
    public int nextState(int stateId, long event) {
        int method = this.methodOffsets[EventCode.decodeMethod(event)];
        int[] transitions = this.transitionTable[stateId][method];
        if (transitions == null) {
            return -1;
        }
        EventCode.EventType type = EventCode.decodeEventType(event);
        if (type == EventCode.EventType.METHOD_CALL) {
            int params = EventCode.decodeParameters(event);
            return transitions[params == -1 ? 0 : params];
        }
        if (type == EventCode.EventType.METHOD_RETURN) {
            int returns = EventCode.decodeReturnValue(event);
            return transitions[(returns == -1 ? 0 : returns) + this.methodReturnEventsOffset[method]];
        }
        throw new IllegalArgumentException("Only method calls and method returns might be observed.");
    }

    @Override
    public int initialState() {
        return this.initialState;
    }

    @Override
    public boolean isFinal(int stateId) {
        return this.finalStates[stateId];
    }

    @Override
    public boolean observesEvent(long event) {
        if (EventCode.isObservable(event)) {
            return this.methodFilter[EventCode.decodeMethod(event)];
        }
        return false;
    }

    @Override
    public boolean observesMethod(int method) {
        return this.methodFilter[method];
    }

    @Override
    public int getNumberOfState() {
        return this.transitionTable.length;
    }

    @Override
    public Map<Long, Integer> getEdges(int state) {
        HashMap<Long, Integer> edges = new HashMap<Long, Integer>();
        for (int method = 0; method < this.methodFilter.length; ++method) {
            if (!this.methodFilter[method]) continue;
            int mIdx = this.methodOffsets[method];
            int[] nextStates = this.transitionTable[state][mIdx];
            int callEvents = this.methodCallEvents[mIdx];
            int returnEvents = this.methodReturnEvents[mIdx];
            int returnEventsOffset = this.methodReturnEventsOffset[mIdx];
            if (nextStates == null) continue;
            int events = returnEventsOffset + (returnEvents == -1 ? 1 : returnEvents);
            for (int eventIdx = 0; eventIdx < events; ++eventIdx) {
                int target = nextStates[eventIdx];
                if (target == -1) continue;
                long eventCode = callEvents == -1 && eventIdx == 0 ? EventCode.encodeMethodCall(method, -1) : (eventIdx < returnEventsOffset ? EventCode.encodeMethodCall(method, eventIdx) : (returnEvents == -1 ? EventCode.encodeMethodReturn(method, -1) : EventCode.encodeMethodReturn(method, eventIdx - returnEventsOffset)));
                edges.put(eventCode, target);
            }
        }
        return edges;
    }

    public static CompactDFA makeCompact(DFA sourceDFA, EventTable eventTable, Set<Integer> filter) {
        CompactDFA dfa = new CompactDFA();
        int states = sourceDFA.getNumberOfState();
        int allMethods = eventTable.getNumberOfMethods();
        int acceptedMethods = filter.size();
        dfa.methodFilter = new boolean[allMethods];
        dfa.methodOffsets = new int[allMethods];
        dfa.methodCallEvents = new int[acceptedMethods];
        dfa.methodReturnEvents = new int[acceptedMethods];
        dfa.methodReturnEventsOffset = new int[acceptedMethods];
        int mIdx = 0;
        for (int method : filter) {
            dfa.methodFilter[method] = true;
            dfa.methodOffsets[method] = mIdx;
            dfa.methodCallEvents[mIdx] = eventTable.getEncoder(method).getNumberOfCallEvents();
            dfa.methodReturnEvents[mIdx] = eventTable.getEncoder(method).getNumberOfReturnEvents();
            dfa.methodReturnEventsOffset[mIdx] = dfa.methodCallEvents[mIdx] == -1 ? 1 : dfa.methodCallEvents[mIdx];
            ++mIdx;
        }
        dfa.transitionTable = new int[states][][];
        dfa.finalStates = new boolean[states];
        for (int state = 0; state < states; ++state) {
            if (sourceDFA.isFinal(state)) {
                dfa.finalStates[state] = true;
            }
            int[][] transitions = new int[acceptedMethods][];
            dfa.transitionTable[state] = transitions;
            for (int method : filter) {
                mIdx = dfa.methodOffsets[method];
                int callEvents = dfa.methodCallEvents[mIdx];
                int returnEvents = dfa.methodReturnEvents[mIdx];
                int returnEventsOffset = dfa.methodReturnEventsOffset[mIdx];
                int[] nextStates = transitions[mIdx];
                int events = returnEventsOffset + (returnEvents == -1 ? 1 : returnEvents);
                for (int eventIdx = 0; eventIdx < events; ++eventIdx) {
                    long eventCode = callEvents == -1 && eventIdx == 0 ? EventCode.encodeMethodCall(method, -1) : (eventIdx < returnEventsOffset ? EventCode.encodeMethodCall(method, eventIdx) : (returnEvents == -1 ? EventCode.encodeMethodReturn(method, -1) : EventCode.encodeMethodReturn(method, eventIdx - returnEventsOffset)));
                    int target = sourceDFA.nextState(state, eventCode);
                    if (target != -1) {
                        if (nextStates == null) {
                            transitions[mIdx] = nextStates = new int[events];
                            if (eventIdx > 0) {
                                Arrays.fill(nextStates, 0, eventIdx, -1);
                            }
                        }
                        nextStates[eventIdx] = target;
                        continue;
                    }
                    if (nextStates == null) continue;
                    nextStates[eventIdx] = target;
                }
            }
        }
        dfa.initialState = sourceDFA.initialState();
        return dfa;
    }
}

