/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.ltsa;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.ow2.dsrg.fm.tbplib.event.EventTable;
import org.ow2.dsrg.fm.tbplib.ltsa.DFA;
import org.ow2.dsrg.fm.tbplib.ltsa.NFA;
import org.ow2.dsrg.fm.tbplib.util.DOTPrintStream;

public class AutomatonToDot {
    public static void printDFAtoDot(DFA dfa, EventTable et, OutputStream stream) {
        DOTPrintStream out = new DOTPrintStream(stream);
        for (int state = 0; state < dfa.getNumberOfState(); ++state) {
            AutomatonToDot.printDFANode(out, dfa, state, et);
        }
        out.DOTclose();
    }

    private static void printDFANode(DOTPrintStream out, DFA a, int state, EventTable et) {
        out.peripheries = state == a.initialState() ? 2 : 1;
        out.filled = a.isFinal(state);
        out.node(state, "");
        for (Map.Entry<Long, Integer> entry : a.getEdges(state).entrySet()) {
            String edge_label = et.decodeEventName(entry.getKey());
            out.edge(state, entry.getValue(), edge_label);
        }
        out.peripheries = 1;
        out.filled = false;
    }

    public static void printNFAtoDot(NFA nfa, EventTable et, OutputStream stream) {
        DOTPrintStream out = new DOTPrintStream(stream);
        for (int state = 0; state < nfa.getNumberOfState(); ++state) {
            AutomatonToDot.printNFANode(out, nfa, state, et);
        }
        out.DOTclose();
    }

    private static void printNFANode(DOTPrintStream out, NFA a, int state, EventTable et) {
        out.peripheries = state == a.initialState() ? 2 : 1;
        out.filled = a.isFinal(state);
        out.node(state, "");
        for (Map.Entry<Long, List<Integer>> entry : a.getEdges(state).entrySet()) {
            String edge_label = et.decodeEventName(entry.getKey());
            for (int target : entry.getValue()) {
                out.edge(state, target, edge_label);
            }
        }
        out.peripheries = 1;
        out.filled = false;
    }
}

