/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.dsrg.fm.tbplib.event.EventCode;
import org.ow2.dsrg.fm.tbplib.event.EventTable;

public class EventTableImpl
implements EventTable {
    protected Map<String, Integer> methodCodes = new HashMap<String, Integer>();
    protected List<EventTable.MethodEncoder> methodInfo = new ArrayList<EventTable.MethodEncoder>();

    @Override
    public int addMethodEncoder(EventTable.MethodEncoder encoder) {
        String methodName = encoder.getMethodName();
        if (this.methodCodes.containsKey(methodName)) {
            throw new IllegalArgumentException("Duplicate method encoder.");
        }
        int code = this.methodInfo.size();
        this.methodInfo.add(encoder);
        this.methodCodes.put(methodName, code);
        encoder.setMethodCode(code);
        return code;
    }

    @Override
    public boolean containsMethod(String methodName) {
        return this.methodCodes.containsKey(methodName);
    }

    @Override
    public int encodeMethod(String methodName) {
        Integer code = this.methodCodes.get(methodName);
        if (code == null) {
            throw new IllegalArgumentException("Method not stored in the EventTable.");
        }
        return code;
    }

    @Override
    public long encodeMethodCall(int method, int ... parameters) {
        return this.methodInfo.get(method).encodeMethodCall(parameters);
    }

    @Override
    public long encodeMethodReturn(int method, int retVal) {
        return this.methodInfo.get(method).encodeMethodReturn(retVal);
    }

    @Override
    public String decodeMethodName(int method) {
        return this.methodInfo.get(method).getMethodName();
    }

    @Override
    public String decodeEventName(long event) {
        EventCode.EventType type = EventCode.decodeEventType(event);
        if (type.equals((Object)EventCode.EventType.SPECIAL)) {
            switch (EventCode.decodeSpecialEvent(event)) {
                case TAU_ACTION: {
                    return "<Tau>";
                }
                case BAD_ACTIVITY: {
                    return "<BadActivity>";
                }
                case NO_ACTIVITY: {
                    return "<NoActivity>";
                }
                case IGNORE_BRANCH: {
                    return "<IgnoreBranch>";
                }
            }
            throw new IllegalArgumentException("Unsupported special event type.");
        }
        int method = EventCode.decodeMethod(event);
        return this.methodInfo.get(method).decodeEventName(event);
    }

    @Override
    public int getNumberOfMethods() {
        return this.methodInfo.size();
    }

    @Override
    public EventTable.MethodEncoder getEncoder(int method) {
        return this.methodInfo.get(method);
    }

    public static class MethodEncoderImpl
    implements EventTable.MethodEncoder {
        protected int methodCode;
        protected String methodName;
        protected int[] parameterDomains;
        protected int retValDomain;

        public MethodEncoderImpl(String methodName, int retValDomain, int ... parameterDomains) {
            this.methodName = methodName;
            this.retValDomain = retValDomain;
            this.parameterDomains = parameterDomains;
        }

        @Override
        public void setMethodCode(int methodCode) {
            this.methodCode = methodCode;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public long encodeMethodCall(int ... parameters) {
            assert (parameters.length == this.parameterDomains.length);
            if (parameters.length == 0) {
                return EventCode.encodeMethodCall(this.methodCode, -1);
            }
            int paramCode = 0;
            for (int i = parameters.length - 1; i >= 0; --i) {
                assert (parameters[i] < this.parameterDomains[i] && 0 <= parameters[i]);
                paramCode += parameters[i];
                paramCode *= i == 0 ? 1 : this.parameterDomains[i - 1];
            }
            return EventCode.encodeMethodCall(this.methodCode, paramCode);
        }

        @Override
        public long encodeMethodReturn(int retVal) {
            assert (retVal < this.retValDomain && 0 <= retVal || this.retValDomain == 0 && retVal == -1);
            return EventCode.encodeMethodReturn(this.methodCode, retVal);
        }

        @Override
        public String decodeEventName(long event) {
            StringBuilder bfr = new StringBuilder(this.methodName);
            EventCode.EventType eventType = EventCode.decodeEventType(event);
            int params = EventCode.decodeParameters(event);
            switch (eventType) {
                case METHOD_CALL: {
                    boolean first = true;
                    bfr.append("^(");
                    for (int dom : this.parameterDomains) {
                        if (first) {
                            first = false;
                        } else {
                            bfr.append(',');
                        }
                        bfr.append(params % dom);
                        params /= dom;
                    }
                    bfr.append(")");
                    break;
                }
                case METHOD_RETURN: {
                    if (params == -1) {
                        bfr.append("$");
                        break;
                    }
                    bfr.append("$:");
                    bfr.append(params);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected event type.");
                }
            }
            return bfr.toString();
        }

        @Override
        public int getNumberOfCallEvents() {
            if (this.parameterDomains == null || this.parameterDomains.length == 0) {
                return -1;
            }
            int events = 1;
            for (int dom : this.parameterDomains) {
                events *= dom;
            }
            return events;
        }

        @Override
        public int getNumberOfReturnEvents() {
            if (this.retValDomain == 0) {
                return -1;
            }
            return this.retValDomain;
        }
    }
}

