/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.event;

public class EventCode {
    public static final int VOID_VALUE = -1;
    private static final int EVENT_TYPE_SHIFT = 62;
    private static final int METHOD_SHIFT = 32;
    private static final int METHOD_CALL_CODE = 0;
    private static final int METHOD_RETURN_CODE = 1;
    private static final int SPECIAL_CODE = 2;
    private static final long EVENT_TYPE_MASK = -4611686018427387904L;
    private static final long METHOD_MASK = 0x3FFFFFFF00000000L;
    private static final long PARAMETERS_MASK = 0xFFFFFFFFL;
    private static final long RETURN_VALUE_MASK = 0xFFFFFFFFL;
    public static final long TAU_ACTION = Long.MIN_VALUE;
    public static final long BAD_ACTIVITY = -9223372036854775807L;
    public static final long NO_ACTIVITY = -9223372036854775806L;
    public static final long IGNORE_BRANCH = -9223372036854775805L;

    public static boolean isObservable(long event) {
        int eventType = (int)((event & 0xC000000000000000L) >>> 62);
        return eventType == 0 || eventType == 1;
    }

    public static int decodeMethod(long event) {
        return (int)((event & 0x3FFFFFFF00000000L) >>> 32);
    }

    public static EventType decodeEventType(long event) {
        switch ((int)((event & 0xC000000000000000L) >>> 62)) {
            case 0: {
                return EventType.METHOD_CALL;
            }
            case 1: {
                return EventType.METHOD_RETURN;
            }
            case 2: {
                return EventType.SPECIAL;
            }
        }
        throw new IllegalArgumentException("Unsupported event type");
    }

    public static SpecialEvent decodeSpecialEvent(long event) {
        switch ((int)(event & 0xFFFFFFFFL)) {
            case 0: {
                return SpecialEvent.TAU_ACTION;
            }
            case 1: {
                return SpecialEvent.BAD_ACTIVITY;
            }
            case 2: {
                return SpecialEvent.NO_ACTIVITY;
            }
            case 3: {
                return SpecialEvent.IGNORE_BRANCH;
            }
        }
        throw new IllegalArgumentException("Unsupported special event type");
    }

    public static int decodeParameters(long event) {
        return (int)(event & 0xFFFFFFFFL);
    }

    public static int decodeReturnValue(long event) {
        return (int)(event & 0xFFFFFFFFL);
    }

    public static long encodeMethodCall(int method, int parameters) {
        return 0L | (long)method << 32 & 0x3FFFFFFF00000000L | (long)parameters & 0xFFFFFFFFL;
    }

    public static long encodeMethodReturn(int method, int retValue) {
        return 0x4000000000000000L | (long)method << 32 & 0x3FFFFFFF00000000L | (long)retValue & 0xFFFFFFFFL;
    }

    public static enum SpecialEvent {
        TAU_ACTION,
        BAD_ACTIVITY,
        NO_ACTIVITY,
        IGNORE_BRANCH;

    }

    public static enum EventType {
        METHOD_CALL,
        METHOD_RETURN,
        SPECIAL;

    }
}

