/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.architecture;

import java.util.LinkedHashMap;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.architecture.Container;
import org.ow2.dsrg.fm.tbplib.architecture.Interface;
import org.ow2.dsrg.fm.tbplib.reference.LocalVariable;
import org.ow2.dsrg.fm.tbplib.reference.MethodSignature;
import org.ow2.dsrg.fm.tbplib.reference.Parameter;
import org.ow2.dsrg.fm.tbplib.reference.Reference;

public class Method
extends Container<Reference>
implements Reference {
    protected MethodSignature<Reference> methodSignature;
    protected Interface iface;
    protected LinkedHashMap<String, Parameter> params = new LinkedHashMap();
    protected LinkedHashMap<String, LocalVariable> locals = new LinkedHashMap();

    public Method(Interface iface, String name) {
        super(name);
        this.iface = iface;
    }

    public void addLocalVariable(LocalVariable localVariable) {
        this.addSymbol(localVariable);
        this.locals.put(localVariable.getName(), localVariable);
    }

    public LinkedHashMap<String, LocalVariable> getLocals() {
        return this.locals;
    }

    public LinkedHashMap<String, Parameter> getParameters() {
        return this.params;
    }

    public MethodSignature<Reference> getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public Interface getParent() {
        return this.iface;
    }

    public void setMethodSignature(MethodSignature<Reference> methodSignature) {
        this.methodSignature = methodSignature;
    }

    public void setParameters(List<Parameter> params) {
        Method.setSymbolsIn(this.params, params);
    }

    public String getFullname() {
        return this.iface.getName() + "." + this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

