/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.architecture;

import java.util.Map;
import org.ow2.dsrg.fm.tbplib.TBPLibLog;
import org.ow2.dsrg.fm.tbplib.architecture.Component;
import org.ow2.dsrg.fm.tbplib.architecture.Container;
import org.ow2.dsrg.fm.tbplib.architecture.Method;
import org.ow2.dsrg.fm.tbplib.reference.Reference;

public class Interface
extends Container<Method>
implements Reference {
    protected Component parent;
    protected Interface boundTo;
    protected Direction direction;

    public Interface(String name, Component parent, Direction direction) {
        super(name);
        this.parent = parent;
        this.direction = direction;
    }

    public void addMethod(Method method) {
        this.symbols.put(method.getName(), method);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Map<String, Method> getMethods() {
        return this.symbols;
    }

    public boolean isBound() {
        assert (this.direction == Direction.REQUIRED);
        return this.boundTo != null;
    }

    public void bindTo(Interface iface) {
        assert (this.direction == Direction.REQUIRED);
        assert (this.boundTo == null);
        TBPLibLog.logger.fine("Binding '" + this.getName() + "' --> '" + iface.getName() + "'");
        this.boundTo = iface;
    }

    public Interface getBoundInterface() {
        return this.boundTo;
    }

    @Override
    public Component getParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static enum Direction {
        PROVIDED,
        REQUIRED;

    }
}

