/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.architecture;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ow2.dsrg.fm.tbplib.architecture.Namespace;
import org.ow2.dsrg.fm.tbplib.reference.Reference;

public abstract class Container<REFERENCE extends Reference>
implements Namespace {
    protected String name;
    protected Map<String, REFERENCE> symbols = new HashMap<String, REFERENCE>();

    public Container(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void addSymbol(REFERENCE symbol) {
        this.symbols.put(symbol.getName(), symbol);
    }

    protected <ANY extends REFERENCE> void addSymbols(Collection<ANY> what) {
        for (Reference s : what) {
            this.addSymbol(s);
        }
    }

    public REFERENCE findSymbol(String name) {
        return (REFERENCE)((Reference)this.symbols.get(name));
    }

    @Override
    public boolean containsSymbol(String name) {
        return this.symbols.containsKey(name);
    }

    protected static <ANY extends Reference> void setSymbolsIn(Map<String, ANY> where, Collection<ANY> what) {
        where.clear();
        for (Reference item : what) {
            where.put(item.getName(), item);
        }
    }

    protected static <ANY extends Reference> void switchSymbolsIn(Map<String, ANY> where, Collection<ANY> oldList, Collection<ANY> newList) {
        if (oldList != null) {
            for (Reference item : oldList) {
                Reference old = (Reference)where.remove(item.getName());
                assert (old == item);
            }
        }
        for (Reference item : newList) {
            where.put(item.getName(), item);
        }
    }

    protected <ANY extends REFERENCE> void switchSymbols(Collection<ANY> oldList, Collection<ANY> newList) {
        if (oldList != null) {
            for (Reference item : oldList) {
                Reference old = (Reference)this.symbols.remove(item.getName());
                assert (old == item);
            }
        }
        this.addSymbols(newList);
    }

    public String toString() {
        return this.name;
    }
}

