/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.architecture;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.architecture.Architecture;
import org.ow2.dsrg.fm.tbplib.architecture.Autonomous;
import org.ow2.dsrg.fm.tbplib.architecture.Container;
import org.ow2.dsrg.fm.tbplib.architecture.Interface;
import org.ow2.dsrg.fm.tbplib.reference.EnumerationType;
import org.ow2.dsrg.fm.tbplib.reference.Reference;
import org.ow2.dsrg.fm.tbplib.reference.StateVariable;

public class Component
extends Container<Reference>
implements Reference {
    protected Architecture architecture;
    protected LinkedHashMap<String, EnumerationType> types = new LinkedHashMap();
    protected LinkedHashMap<String, StateVariable> stateVariables = new LinkedHashMap();
    protected LinkedHashMap<String, Autonomous> threads = new LinkedHashMap();
    protected LinkedHashMap<String, Interface> providedIfaces = new LinkedHashMap();
    protected LinkedHashMap<String, Interface> requiredIfaces = new LinkedHashMap();

    protected Component(String name) {
        super(name);
    }

    public Component(String name, List<EnumerationType> types, List<StateVariable> stateVariables) {
        super(name);
        this.setTypes(types);
        this.setStateVariables(stateVariables);
    }

    public Component(String name, List<EnumerationType> types) {
        super(name);
        this.setTypes(types);
    }

    public void setStateVariables(List<StateVariable> stateVariables) {
        this.switchSymbols(this.stateVariables.values(), stateVariables);
        Component.setSymbolsIn(this.stateVariables, stateVariables);
    }

    private void setTypes(List<EnumerationType> types) {
        for (EnumerationType type : types) {
            if (this.architecture != null) {
                type = this.architecture.addType(type);
            }
            this.types.put(type.getName(), type);
            this.addSymbol(type);
        }
    }

    public void addThread(Autonomous thread) {
        String threadName = thread.getName();
        if (this.threads.containsKey(threadName)) {
            throw new TBPResolvingException("Multiple threads share the same name: " + threadName);
        }
        this.threads.put(threadName, thread);
    }

    public void addProvidedInterface(Interface iface) {
        assert (iface.getDirection() == Interface.Direction.PROVIDED);
        this.providedIfaces.put(iface.getName(), iface);
    }

    public void addRequiredInterface(Interface iface) {
        assert (iface.getDirection() == Interface.Direction.REQUIRED);
        this.requiredIfaces.put(iface.getName(), iface);
    }

    public LinkedHashMap<String, Interface> getProvidedInterfaces() {
        return this.providedIfaces;
    }

    public LinkedHashMap<String, Interface> getRequiredInterfaces() {
        return this.requiredIfaces;
    }

    public LinkedHashMap<String, Autonomous> getThreads() {
        return this.threads;
    }

    public void addStateVariable(StateVariable stateVariable) {
        this.stateVariables.put(stateVariable.getName(), stateVariable);
        this.addSymbol(stateVariable);
    }

    @Override
    public Architecture getParent() {
        return this.architecture;
    }

    void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
        for (Map.Entry<String, EnumerationType> entry : this.types.entrySet()) {
            entry.setValue(architecture.addType(entry.getValue()));
        }
    }

    public LinkedHashMap<String, EnumerationType> getTypes() {
        return this.types;
    }

    public LinkedHashMap<String, StateVariable> getStateVariables() {
        return this.stateVariables;
    }
}

