/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib.architecture;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.dsrg.fm.tbplib.TBPResolvingException;
import org.ow2.dsrg.fm.tbplib.architecture.Component;
import org.ow2.dsrg.fm.tbplib.architecture.Container;
import org.ow2.dsrg.fm.tbplib.architecture.Namespace;
import org.ow2.dsrg.fm.tbplib.reference.EnumerationType;
import org.ow2.dsrg.fm.tbplib.reference.Reference;

public class Architecture
extends Container<Reference>
implements Reference {
    protected Map<String, EnumerationType> types = new HashMap<String, EnumerationType>();
    protected List<Component> components = new ArrayList<Component>();

    public Architecture(String name) {
        super(name);
        this.addType(EnumerationType.MUTEX_TYPE);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public EnumerationType addType(EnumerationType type) {
        EnumerationType older = this.types.get(type.getName());
        if (older != null) {
            if (older.equals(type)) {
                type = older;
            } else {
                throw new TBPResolvingException("Duplicate definition of an enumeration type that is not identical: " + type.getName());
            }
        }
        this.types.put(type.getName(), type);
        this.addSymbol(type);
        return type;
    }

    public Map<String, EnumerationType> getTypes() {
        return this.types;
    }

    @Override
    public Namespace getParent() {
        return null;
    }

    public void addComponent(Component comp) {
        for (Component c : this.components) {
            if (!comp.getName().equals(c.getName())) continue;
            throw new TBPResolvingException("Component of the given name is already present in the architecture: " + c.getName());
        }
        comp.setArchitecture(this);
        this.components.add(comp);
    }
}

