/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ow2.dsrg.fm.tbplib.MethodsInfo;
import org.ow2.dsrg.fm.tbplib.TBPMethodNamePattern;
import org.ow2.dsrg.fm.tbplib.node.TBPAccept;
import org.ow2.dsrg.fm.tbplib.node.TBPNode;

public class TBPProvisionMethodsNameChecker {
    private List<TBPMethodNamePattern> methodsPattern = new LinkedList<TBPMethodNamePattern>();

    public void addMethodPattern(TBPMethodNamePattern pattern) {
        this.methodsPattern.add(pattern);
    }

    public void checkMethodsInSubtree(TBPNode<String> provisionNode) {
        for (TBPNode<String> node : provisionNode.getChildren()) {
            if (node instanceof TBPAccept) {
                TBPAccept accept = (TBPAccept)node;
                if (!MethodsInfo.isMethodProvided((String)accept.getInterface(), (String)accept.getMethod())) {
                    throw new RuntimeException("Method " + accept.getFullname() + " used in a provision is not provided method.");
                }
                if (!this.matchMethodToSomeMethodNamePatternInForSection((String)accept.getInterface(), (String)accept.getMethod())) {
                    throw new RuntimeException("Method " + accept.getFullname() + " used in a provision is not specified in for section of the provision.");
                }
            }
            this.checkMethodsInSubtree(node);
        }
    }

    private boolean matchMethodToSomeMethodNamePatternInForSection(String interfaceName, String methodName) {
        Iterator<TBPMethodNamePattern> it = this.methodsPattern.iterator();
        while (it.hasNext()) {
            if (!it.next().matchMethod(interfaceName, methodName)) continue;
            return true;
        }
        return false;
    }
}

