/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MethodsInfo {
    private static MethodsInfo actualMethodsInfo;
    private final Set<String> providedMethods = new HashSet<String>();
    private final Set<String> requiredMethods = new HashSet<String>();

    private MethodsInfo(String tbpFileName) {
        tbpFileName = tbpFileName.substring(0, tbpFileName.length() - 4);
        this.readMethodsFromFileToSet(tbpFileName + "_provided_methods", this.providedMethods);
        this.readMethodsFromFileToSet(tbpFileName + "_required_methods", this.requiredMethods);
    }

    public static void changeTBPSpecification(String tbpSpecificationFilename) {
        actualMethodsInfo = new MethodsInfo(tbpSpecificationFilename);
    }

    public String toString() {
        return "provided methods: " + this.providedMethods.toString() + "\n" + "required methods: " + this.requiredMethods.toString();
    }

    public static boolean isMethodProvided(String interfaceName, String methodName) {
        return MethodsInfo.actualMethodsInfo.providedMethods.contains(interfaceName + "." + methodName);
    }

    private void readMethodsFromFileToSet(String filename, Set<String> set) {
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(filename));
            while ((str = in.readLine()) != null) {
                set.add(str);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

