/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbplib;

import java.util.List;

public class Annotation {
    private final String name;
    private final List<String> names;
    private final List<String> values;

    public Annotation(String name, List<String> keys, List<String> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("Keys and values do not match");
        }
        this.name = name;
        this.names = keys;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getKeys() {
        return this.names;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("@");
        int s = this.values.size();
        bld.append(this.name);
        if (s > 0) {
            bld.append("(");
            for (int i = 0; i < s; ++i) {
                bld.append(this.names.get(i)).append("=").append(this.values.get(i));
                if (i == s - 1) continue;
                bld.append(", ");
            }
            bld.append(")");
        }
        return bld.toString();
    }
}

