/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.stringformatters;

import de.uka.ipd.sdq.logger.stringformatters.ByteIDFormatter;
import de.uka.ipd.sdq.logger.stringformatters.ClassFormatter;
import de.uka.ipd.sdq.logger.stringformatters.DateFormatter;
import de.uka.ipd.sdq.logger.stringformatters.IObjectToStringFormatter;
import de.uka.ipd.sdq.logger.stringformatters.LogTypeFormatter;
import de.uka.ipd.sdq.logger.stringformatters.StringTrimFormatter;
import java.util.Hashtable;

public class ObjectToStringFormatter {
    private Hashtable<Class<Object>, IObjectToStringFormatter> objectToStringFormatters = new Hashtable();

    public ObjectToStringFormatter() {
        this.preconfigure();
    }

    private void preconfigure() {
        this.addObjectToStringFormatter(new DateFormatter());
        this.addObjectToStringFormatter(new ClassFormatter());
        this.addObjectToStringFormatter(new LogTypeFormatter(255));
        this.addObjectToStringFormatter(new StringTrimFormatter(255));
        this.addObjectToStringFormatter(new ByteIDFormatter());
    }

    public void addObjectToStringFormatter(IObjectToStringFormatter formatter) {
        Class treatedClass = formatter.getFormattableClass();
        if (this.objectToStringFormatters.containsKey(treatedClass)) {
            this.objectToStringFormatters.remove(treatedClass);
        }
        this.objectToStringFormatters.put(treatedClass, formatter);
    }

    public String formatObjectToString(Object obj) {
        if (obj != null) {
            if (this.objectToStringFormatters.containsKey(obj.getClass())) {
                return this.objectToStringFormatters.get(obj.getClass()).getStringFormat(obj);
            }
            return obj.toString();
        }
        return "null";
    }
}

