/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.rmi;

import de.uka.ipd.sdq.logger.Log;
import de.uka.ipd.sdq.logger.Logger;
import de.uka.ipd.sdq.logger.registry.Settings;
import de.uka.ipd.sdq.logger.rmi.ILogServer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class RmiLogServer
implements ILogServer {
    private static org.apache.log4j.Logger debugLogger = org.apache.log4j.Logger.getLogger((String)RmiLogServer.class.getName());

    @Override
    public Logger getPreconfiguredLogger(String localInstanceName, String fullQualifiedClassName) throws RemoteException {
        return Log.getRmiLogger(localInstanceName, fullQualifiedClassName);
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            RmiLogServer rmiLog = new RmiLogServer();
            ILogServer stub = (ILogServer)UnicastRemoteObject.exportObject((Remote)rmiLog, 0);
            Registry registry = LocateRegistry.getRegistry(new Settings().getRmiPort());
            registry.rebind(new Settings().getRmiServerClass(), stub);
            debugLogger.info((Object)"RmiLog bound. Ready for accepting logging clients.");
        }
        catch (Exception e) {
            debugLogger.error((Object)("RmiLog error. Please check for running instance of RMI registry and RMI port configuration. " + e.getMessage()));
        }
    }
}

