/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.logger.registry;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Settings {
    private static Logger debugLogger = Logger.getLogger((String)Settings.class.getName());
    private String rmiHost;
    private String rmiPort;
    private String rmiServerClass;

    public Settings() {
        this.initFromProperties();
    }

    public Settings(boolean useConfigFile) {
        if (useConfigFile) {
            this.initFromProperties();
        }
    }

    private void initFromProperties() {
        Properties properties = new Properties();
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            properties.load(new FileInputStream("rmi-logger.properties"));
            this.rmiHost = properties.getProperty("de.uka.ipd.sdq.logger.rmi.host");
            this.rmiPort = properties.getProperty("de.uka.ipd.sdq.logger.rmi.portt");
            this.rmiServerClass = properties.getProperty("de.uka.ipd.sdq.logger.rmi.serverclass");
        }
        catch (IOException e) {
            debugLogger.error((Object)"Could not read config/rmi-logger.properties.", (Throwable)e);
        }
    }

    public void setRmiHost(String rmiHost) {
        this.rmiHost = rmiHost;
    }

    public String getRmiHost() {
        return this.rmiHost;
    }

    public void setRmiPort(String rmiPort) {
        this.rmiPort = rmiPort;
    }

    public String getRmiPort() {
        return this.rmiPort;
    }

    public void setRmiServerClass(String rmiServerClass) {
        this.rmiServerClass = rmiServerClass;
    }

    public String getRmiServerClass() {
        return this.rmiServerClass;
    }
}

